/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0006H\u0087\u0002\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0006H\u0003\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0006J,\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000e0\u00062\u0006\u0010\u0016\u001a\u0002H\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J!\u0010\u001a\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0006\u00a2\u0006\u0002\u0010\u0010R\u001b\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/ResultRow;", "", "size", "", "fieldIndex", "", "Lorg/jetbrains/exposed/sql/Expression;", "(ILjava/util/Map;)V", "data", "", "getData", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "get", "T", "c", "(Lorg/jetbrains/exposed/sql/Expression;)Ljava/lang/Object;", "getRaw", "hasValue", "", "set", "", "value", "(Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/Object;)V", "toString", "", "tryGet", "Companion", "NotInitializedValue", "exposed"})
public final class ResultRow {
    @NotNull
    private final Object[] data;
    private final Map<Expression<?>, Integer> fieldIndex;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Object[] getData() {
        return this.data;
    }

    public final <T> T get(@NotNull Expression<T> c) {
        Object object;
        T d;
        Intrinsics.checkParameterIsNotNull(c, "c");
        T t = d = this.getRaw(c);
        if (t != null) {
            Object object2;
            T t2;
            T it = t2 = t;
            if (Intrinsics.areEqual(d, NotInitializedValue.INSTANCE)) {
                String string = "" + c.toSQL(new QueryBuilder(false)) + " is not initialized yet";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Expression<T> expression = c;
            if (!(expression instanceof ExpressionWithColumnType)) {
                expression = null;
            }
            if ((object2 = (ExpressionWithColumnType)expression) == null || (object2 = ((ExpressionWithColumnType)object2).getColumnType()) == null || (object2 = object2.valueFromDB(it)) == null) {
                object2 = object = it;
            }
            if (object2 == null) {
                Column column;
                ResultRow resultRow;
                ResultRow $receiver = resultRow = this;
                Expression<T> expression2 = c;
                if (!(expression2 instanceof Column)) {
                    expression2 = null;
                }
                Column column2 = column = (Column)expression2;
                if ((column2 != null ? column2.getDbDefaultValue$exposed() : null) != null && !column.getColumnType().getNullable()) {
                    SQLLogKt.getExposedLogger().warn("Column " + TransactionManager.Companion.current().identity(column) + " is marked as not null, " + "has default db value, but returns null. Possible have to re-read it from DB.");
                }
                object = null;
            }
        } else {
            object = null;
        }
        return (T)object;
    }

    public final <T> void set(@NotNull Expression<? extends T> c, T value) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Integer n = this.fieldIndex.get(c);
        if (n == null) {
            String string = "" + c.toSQL(new QueryBuilder(false)) + " is not in record set";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int index = n;
        this.data[index] = value;
    }

    public final <T> boolean hasValue(@NotNull Expression<T> c) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(c, "c");
        Integer n = this.fieldIndex.get(c);
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            bl = Intrinsics.areEqual(this.data[it], NotInitializedValue.INSTANCE) ^ true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final <T> T tryGet(@NotNull Expression<T> c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        return this.hasValue(c) ? (T)this.get(c) : null;
    }

    private final <T> T getRaw(Expression<T> c) {
        Object[] objectArray = this.data;
        Integer n = this.fieldIndex.get(c);
        if (n == null) {
            String string = "" + c.toSQL(new QueryBuilder(false)) + " is not in record set";
            Object[] objectArray2 = objectArray;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (T)objectArray[n];
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.fieldIndex.entrySet(), null, null, null, 0, null, new Function1<Map.Entry<? extends Expression<?>, ? extends Integer>, String>(this){
            final /* synthetic */ ResultRow this$0;

            @NotNull
            public final String invoke(@NotNull Map.Entry<? extends Expression<?>, Integer> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return "" + it.getKey().toSQL(new QueryBuilder(false)) + '=' + this.this$0.getData()[((Number)it.getValue()).intValue()];
            }
            {
                this.this$0 = resultRow;
                super(1);
            }
        }, 31, null);
    }

    public ResultRow(int size, @NotNull Map<Expression<?>, Integer> fieldIndex) {
        Intrinsics.checkParameterIsNotNull(fieldIndex, "fieldIndex");
        this.fieldIndex = fieldIndex;
        this.data = new Object[size];
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/ResultRow$NotInitializedValue;", "", "()V", "exposed"})
    public static final class NotInitializedValue {
        public static final NotInitializedValue INSTANCE;

        private NotInitializedValue() {
        }

        static {
            NotInitializedValue notInitializedValue;
            INSTANCE = notInitializedValue = new NotInitializedValue();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0016\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\f0\u000bJ\u001f\u0010\u0003\u001a\u00020\u00042\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\bH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/sql/ResultRow$Companion;", "", "()V", "create", "Lorg/jetbrains/exposed/sql/ResultRow;", "rs", "Ljava/sql/ResultSet;", "fields", "", "Lorg/jetbrains/exposed/sql/Expression;", "fieldsIndex", "", "", "columns", "Lorg/jetbrains/exposed/sql/Column;", "create$exposed", "exposed"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ResultRow create(@NotNull ResultSet rs, @NotNull List<? extends Expression<?>> fields2, @NotNull Map<Expression<?>, Integer> fieldsIndex) {
            Intrinsics.checkParameterIsNotNull(rs, "rs");
            Intrinsics.checkParameterIsNotNull(fields2, "fields");
            Intrinsics.checkParameterIsNotNull(fieldsIndex, "fieldsIndex");
            int size = fieldsIndex.size();
            ResultRow answer = new ResultRow(size, fieldsIndex);
            Iterable $receiver$iv = fields2;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                Object object;
                void f;
                int n = index$iv++;
                Expression expression = (Expression)item$iv;
                int i = n;
                Object[] objectArray = answer.getData();
                Object v2 = f;
                if (!(v2 instanceof Column)) {
                    v2 = null;
                }
                if ((object = (Column)v2) == null || (object = ((Column)object).getColumnType()) == null || (object = object.readObject(rs, i + 1)) == null) {
                    object = rs.getObject(i + 1);
                }
                objectArray[i] = object;
            }
            return answer;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ResultRow create$exposed(@NotNull List<? extends Column<?>> columns2) {
            Collection<Pair<void, Integer>> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            ResultRow resultRow;
            Intrinsics.checkParameterIsNotNull(columns2, "columns");
            Object object = columns2;
            int n = columns2.size();
            ResultRow resultRow2 = resultRow;
            ResultRow resultRow3 = resultRow;
            void var3_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void i;
                void c;
                int n2 = index$iv$iv++;
                Column column = (Column)item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                Pair<void, Integer> pair = TuplesKt.to(c, (int)i);
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            resultRow2(n, MapsKt.toMap((Iterable)collection));
            Object $receiver = object = resultRow3;
            Iterable $receiver$iv2 = columns2;
            for (Object element$iv : $receiver$iv2) {
                Column it = (Column)element$iv;
                Expression expression = it;
                Function0 function0 = it.getDefaultValueFun$exposed();
                if (function0 == null || (function0 = function0.invoke()) == null) {
                    function0 = !it.getColumnType().getNullable() ? NotInitializedValue.INSTANCE : null;
                }
                ((ResultRow)$receiver).set(expression, function0);
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

