/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u0013\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016J\u000e\u0010!\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\"\u001a\u00020\u0003H\u0016R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/jetbrains/exposed/sql/Index;", "Lorg/jetbrains/exposed/sql/DdlAware;", "indexName", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "unique", "", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Z)V", "getColumns", "()Ljava/util/List;", "getIndexName", "()Ljava/lang/String;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "getUnique", "()Z", "component1", "component2", "component3", "component4", "copy", "createStatement", "dropStatement", "equals", "other", "", "hashCode", "", "modifyStatement", "onlyNameDiffer", "toString", "Companion", "exposed"})
public final class Index
implements DdlAware {
    @NotNull
    private final String indexName;
    @NotNull
    private final Table table;
    @NotNull
    private final List<Column<?>> columns;
    private final boolean unique;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<String> createStatement() {
        return CollectionsKt.listOf(DefaultKt.getCurrentDialect().createIndex(this));
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        return CollectionsKt.listOf(DefaultKt.getCurrentDialect().dropIndex(this.table.nameInDatabaseCase(), this.indexName));
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    public final boolean onlyNameDiffer(@NotNull Index other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return Intrinsics.areEqual(this.indexName, other.indexName) ^ true && Intrinsics.areEqual(this.columns, other.columns) && this.unique == other.unique;
    }

    @NotNull
    public String toString() {
        return "" + (this.unique ? "Unique " : "") + "Index '" + this.indexName + "' for '" + this.table.nameInDatabaseCase() + "' on columns " + CollectionsKt.joinToString$default(this.columns, ", ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final List<Column<?>> getColumns() {
        return this.columns;
    }

    public final boolean getUnique() {
        return this.unique;
    }

    public Index(@NotNull String indexName2, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, boolean unique) {
        Intrinsics.checkParameterIsNotNull(indexName2, "indexName");
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(columns2, "columns");
        this.indexName = indexName2;
        this.table = table;
        this.columns = columns2;
        this.unique = unique;
    }

    @NotNull
    public final String component1() {
        return this.indexName;
    }

    @NotNull
    public final Table component2() {
        return this.table;
    }

    @NotNull
    public final List<Column<?>> component3() {
        return this.columns;
    }

    public final boolean component4() {
        return this.unique;
    }

    @NotNull
    public final Index copy(@NotNull String indexName2, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, boolean unique) {
        Intrinsics.checkParameterIsNotNull(indexName2, "indexName");
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(columns2, "columns");
        return new Index(indexName2, table, columns2, unique);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Index copy$default(Index index, String string, Table table, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = index.indexName;
        }
        if ((n & 2) != 0) {
            table = index.table;
        }
        if ((n & 4) != 0) {
            list = index.columns;
        }
        if ((n & 8) != 0) {
            bl = index.unique;
        }
        return index.copy(string, table, list, bl);
    }

    public int hashCode() {
        String string = this.indexName;
        Table table = this.table;
        List<Column<?>> list = this.columns;
        int n = (((string != null ? string.hashCode() : 0) * 31 + (table != null ? ((Object)table).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31;
        int n2 = this.unique ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Index)) break block3;
                Index index = (Index)object;
                if (!Intrinsics.areEqual(this.indexName, index.indexName) || !Intrinsics.areEqual(this.table, index.table) || !Intrinsics.areEqual(this.columns, index.columns) || !(this.unique == index.unique)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\"\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/exposed/sql/Index$Companion;", "", "()V", "forColumns", "Lorg/jetbrains/exposed/sql/Index;", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "unique", "", "([Lorg/jetbrains/exposed/sql/Column;Z)Lorg/jetbrains/exposed/sql/Index;", "exposed"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Index forColumns(@NotNull Column<?>[] columns2, boolean unique) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            boolean bl;
            Object[] objectArray;
            Intrinsics.checkParameterIsNotNull(columns2, "columns");
            Object object = objectArray = (Object[])columns2;
            boolean bl2 = bl = !(((Object[])object).length == 0);
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(object));
            }
            object = $receiver$iv = (Object[])columns2;
            Map destination$iv$iv = new LinkedHashMap();
            int n = ((void)$receiver$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Object object2;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                void element$iv$iv = $receiver$iv$iv[i];
                Column it = (Column)element$iv$iv;
                Table key$iv$iv = it.getTable();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            boolean bl3 = $receiver$iv = destination$iv$iv.size() == 1;
            if (_Assertions.ENABLED && !$receiver$iv) {
                String string = "Columns from different tables can't persist in one index";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            String indexName2 = "" + ((Column)ArraysKt.first((Object[])columns2)).getTable().nameInDatabaseCase() + '_' + ArraysKt.joinToString$default(columns2, (CharSequence)"_", null, null, 0, null, (Function1)forColumns.indexName.1.INSTANCE, 30, null) + (unique ? DefaultKt.inProperCase("_unique") : "");
            return new Index(indexName2, ((Column)ArraysKt.first((Object[])columns2)).getTable(), ArraysKt.toList((Object[])columns2), unique);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

