/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003JE\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "fkName", "", "refereeTable", "refereeColumn", "referencedTable", "referencedColumn", "deleteRule", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/exposed/sql/ReferenceOption;)V", "getDeleteRule", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "setDeleteRule", "(Lorg/jetbrains/exposed/sql/ReferenceOption;)V", "getFkName", "()Ljava/lang/String;", "foreignKeyPart", "getForeignKeyPart$exposed", "getRefereeColumn", "getRefereeTable", "getReferencedColumn", "getReferencedTable", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "createStatement", "", "dropStatement", "equals", "", "other", "", "hashCode", "", "modifyStatement", "toString", "Companion", "exposed"})
public final class ForeignKeyConstraint
implements DdlAware {
    @NotNull
    private final String foreignKeyPart;
    @NotNull
    private final String fkName;
    @NotNull
    private final String refereeTable;
    @NotNull
    private final String refereeColumn;
    @NotNull
    private final String referencedTable;
    @NotNull
    private final String referencedColumn;
    @NotNull
    private ReferenceOption deleteRule;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getForeignKeyPart$exposed() {
        return this.foreignKeyPart;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        CharSequence charSequence = this.fkName;
        StringBuilder stringBuilder = new StringBuilder().append("ALTER TABLE ").append(this.referencedTable).append(" ADD");
        boolean bl = !StringsKt.isBlank(charSequence);
        return CollectionsKt.listOf(stringBuilder.append(bl ? " CONSTRAINT " + this.fkName : "" + this.foreignKeyPart).toString());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        DatabaseDialect databaseDialect;
        return CollectionsKt.listOf("ALTER TABLE " + this.refereeTable + " DROP " + ((databaseDialect = DefaultKt.getCurrentDialect()) instanceof MysqlDialect ? "FOREIGN KEY " : "CONSTRAINT ") + this.fkName);
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @NotNull
    public final String getFkName() {
        return this.fkName;
    }

    @NotNull
    public final String getRefereeTable() {
        return this.refereeTable;
    }

    @NotNull
    public final String getRefereeColumn() {
        return this.refereeColumn;
    }

    @NotNull
    public final String getReferencedTable() {
        return this.referencedTable;
    }

    @NotNull
    public final String getReferencedColumn() {
        return this.referencedColumn;
    }

    @NotNull
    public final ReferenceOption getDeleteRule() {
        return this.deleteRule;
    }

    public final void setDeleteRule(@NotNull ReferenceOption referenceOption) {
        Intrinsics.checkParameterIsNotNull((Object)referenceOption, "<set-?>");
        this.deleteRule = referenceOption;
    }

    public ForeignKeyConstraint(@NotNull String fkName, @NotNull String refereeTable, @NotNull String refereeColumn, @NotNull String referencedTable, @NotNull String referencedColumn, @NotNull ReferenceOption deleteRule) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(fkName, "fkName");
        Intrinsics.checkParameterIsNotNull(refereeTable, "refereeTable");
        Intrinsics.checkParameterIsNotNull(refereeColumn, "refereeColumn");
        Intrinsics.checkParameterIsNotNull(referencedTable, "referencedTable");
        Intrinsics.checkParameterIsNotNull(referencedColumn, "referencedColumn");
        Intrinsics.checkParameterIsNotNull((Object)deleteRule, "deleteRule");
        this.fkName = fkName;
        this.refereeTable = refereeTable;
        this.refereeColumn = refereeColumn;
        this.referencedTable = referencedTable;
        this.referencedColumn = referencedColumn;
        this.deleteRule = deleteRule;
        ForeignKeyConstraint foreignKeyConstraint = this;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(" FOREIGN KEY (" + this.referencedColumn + ") REFERENCES " + this.refereeTable + '(' + this.refereeColumn + ')');
        if (Intrinsics.areEqual((Object)this.deleteRule, (Object)ReferenceOption.NO_ACTION) ^ true) {
            $receiver.append(" ON DELETE " + (Object)((Object)this.deleteRule));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "StringBuilder().apply(builderAction).toString()");
        foreignKeyConstraint.foreignKeyPart = string = string2;
    }

    @NotNull
    public final String component1() {
        return this.fkName;
    }

    @NotNull
    public final String component2() {
        return this.refereeTable;
    }

    @NotNull
    public final String component3() {
        return this.refereeColumn;
    }

    @NotNull
    public final String component4() {
        return this.referencedTable;
    }

    @NotNull
    public final String component5() {
        return this.referencedColumn;
    }

    @NotNull
    public final ReferenceOption component6() {
        return this.deleteRule;
    }

    @NotNull
    public final ForeignKeyConstraint copy(@NotNull String fkName, @NotNull String refereeTable, @NotNull String refereeColumn, @NotNull String referencedTable, @NotNull String referencedColumn, @NotNull ReferenceOption deleteRule) {
        Intrinsics.checkParameterIsNotNull(fkName, "fkName");
        Intrinsics.checkParameterIsNotNull(refereeTable, "refereeTable");
        Intrinsics.checkParameterIsNotNull(refereeColumn, "refereeColumn");
        Intrinsics.checkParameterIsNotNull(referencedTable, "referencedTable");
        Intrinsics.checkParameterIsNotNull(referencedColumn, "referencedColumn");
        Intrinsics.checkParameterIsNotNull((Object)deleteRule, "deleteRule");
        return new ForeignKeyConstraint(fkName, refereeTable, refereeColumn, referencedTable, referencedColumn, deleteRule);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ForeignKeyConstraint copy$default(ForeignKeyConstraint foreignKeyConstraint, String string, String string2, String string3, String string4, String string5, ReferenceOption referenceOption, int n, Object object) {
        if ((n & 1) != 0) {
            string = foreignKeyConstraint.fkName;
        }
        if ((n & 2) != 0) {
            string2 = foreignKeyConstraint.refereeTable;
        }
        if ((n & 4) != 0) {
            string3 = foreignKeyConstraint.refereeColumn;
        }
        if ((n & 8) != 0) {
            string4 = foreignKeyConstraint.referencedTable;
        }
        if ((n & 0x10) != 0) {
            string5 = foreignKeyConstraint.referencedColumn;
        }
        if ((n & 0x20) != 0) {
            referenceOption = foreignKeyConstraint.deleteRule;
        }
        return foreignKeyConstraint.copy(string, string2, string3, string4, string5, referenceOption);
    }

    public String toString() {
        return "ForeignKeyConstraint(fkName=" + this.fkName + ", refereeTable=" + this.refereeTable + ", refereeColumn=" + this.refereeColumn + ", referencedTable=" + this.referencedTable + ", referencedColumn=" + this.referencedColumn + ", deleteRule=" + (Object)((Object)this.deleteRule) + ")";
    }

    public int hashCode() {
        String string = this.fkName;
        String string2 = this.refereeTable;
        String string3 = this.refereeColumn;
        String string4 = this.referencedTable;
        String string5 = this.referencedColumn;
        ReferenceOption referenceOption = this.deleteRule;
        return (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (referenceOption != null ? ((Object)((Object)referenceOption)).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ForeignKeyConstraint)) break block3;
                ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)object;
                if (!Intrinsics.areEqual(this.fkName, foreignKeyConstraint.fkName) || !Intrinsics.areEqual(this.refereeTable, foreignKeyConstraint.refereeTable) || !Intrinsics.areEqual(this.refereeColumn, foreignKeyConstraint.refereeColumn) || !Intrinsics.areEqual(this.referencedTable, foreignKeyConstraint.referencedTable) || !Intrinsics.areEqual(this.referencedColumn, foreignKeyConstraint.referencedColumn) || !Intrinsics.areEqual((Object)this.deleteRule, (Object)foreignKeyConstraint.deleteRule)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/ForeignKeyConstraint$Companion;", "", "()V", "from", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "column", "Lorg/jetbrains/exposed/sql/Column;", "exposed"})
    public static final class Companion {
        @NotNull
        public final ForeignKeyConstraint from(@NotNull Column<?> column) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(column, "column");
            boolean bl2 = bl = column.getReferee() != null && column.getOnDelete$exposed() != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "" + column + " does not reference anything";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Transaction s = TransactionManager.Companion.current();
            Column<?> column2 = column.getReferee();
            if (column2 == null) {
                Intrinsics.throwNpe();
            }
            String string = s.identity(column2.getTable());
            Column<?> column3 = column.getReferee();
            if (column3 == null) {
                Intrinsics.throwNpe();
            }
            String string2 = s.identity(column3);
            String string3 = s.identity(column.getTable());
            String string4 = s.identity(column);
            ReferenceOption referenceOption = column.getOnDelete$exposed();
            if (referenceOption == null) {
                Intrinsics.throwNpe();
            }
            return new ForeignKeyConstraint("", string, string2, string3, string4, referenceOption);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

