/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "klass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "getKlass", "()Ljava/lang/Class;", "notNullValueToDB", "", "value", "sqlType", "", "valueFromDB", "exposed"})
public final class EnumerationColumnType<T extends Enum<T>>
extends ColumnType {
    @NotNull
    private final Class<T> klass;

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().shortType();
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        int n;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (object instanceof Enum) {
            n = ((Enum)value).ordinal();
        } else {
            String string = "" + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Enum enum_;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof Number) {
            T[] TArray = this.klass.getEnumConstants();
            if (TArray == null) {
                Intrinsics.throwNpe();
            }
            enum_ = ((Enum[])TArray)[((Number)value).intValue()];
        } else if (object instanceof Enum) {
            enum_ = (Enum)value;
        } else {
            String string = "" + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull(enum_, "when (value) {\n        i\u2026num ${klass.name}\")\n    }");
        return enum_;
    }

    @NotNull
    public final Class<T> getKlass() {
        return this.klass;
    }

    public EnumerationColumnType(@NotNull Class<T> klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        super(false, 1, null);
        this.klass = klass;
    }
}

