/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.EntityID;
import org.jetbrains.exposed.dao.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.Table;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/exposed/sql/EntityIDColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "idColumn", "Lorg/jetbrains/exposed/sql/Column;", "(Lorg/jetbrains/exposed/sql/Column;)V", "getIdColumn", "()Lorg/jetbrains/exposed/sql/Column;", "notNullValueToDB", "", "value", "sqlType", "", "valueFromDB", "exposed"})
public final class EntityIDColumnType<T extends Comparable<? super T>>
extends ColumnType {
    @NotNull
    private final Column<T> idColumn;

    @Override
    @NotNull
    public String sqlType() {
        return this.idColumn.getColumnType().sqlType();
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        return this.idColumn.getColumnType().notNullValueToDB(object instanceof EntityID ? ((EntityID)value).getValue() : value);
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        EntityID entityID;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof EntityID) {
            Object t = ((EntityID)value).getValue();
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            Table table = this.idColumn.getTable();
            if (table == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.exposed.dao.IdTable<T>");
            }
            entityID = new EntityID(t, (IdTable)table);
        } else {
            Object object2 = this.idColumn.getColumnType().valueFromDB(value);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            Table table = this.idColumn.getTable();
            if (table == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.exposed.dao.IdTable<T>");
            }
            entityID = new EntityID<Comparable>((Comparable)object2, (IdTable)table);
        }
        return entityID;
    }

    @NotNull
    public final Column<T> getIdColumn() {
        return this.idColumn;
    }

    public EntityIDColumnType(@NotNull Column<T> idColumn) {
        Intrinsics.checkParameterIsNotNull(idColumn, "idColumn");
        super(false);
        this.idColumn = idColumn;
        boolean bl = this.idColumn.getTable() instanceof IdTable;
        if (_Assertions.ENABLED && !bl) {
            String string = "EntityId supported only for IdTables";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

