/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.Date;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/sql/DateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "time", "", "(Z)V", "getTime", "()Z", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "exposed"})
public final class DateColumnType
extends ColumnType {
    private final boolean time;

    @Override
    @NotNull
    public String sqlType() {
        return this.time ? DefaultKt.getCurrentDialect().getDataTypeProvider().dateTimeType() : "DATE";
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        DateTime dateTime;
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof String) {
            return (String)value;
        }
        Object object = value;
        if (object instanceof DateTime) {
            dateTime = (DateTime)value;
        } else if (object instanceof Date) {
            dateTime = new DateTime(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            dateTime = new DateTime(((Timestamp)value).getTime());
        } else {
            String string = "Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        DateTime dateTime2 = dateTime;
        return this.time ? '\'' + ColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p().print(dateTime2.toDateTime(DateTimeZone.getDefault())) + '\'' : '\'' + ColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER$p().print(dateTime2) + '\'';
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        Object object2 = object instanceof DateTime ? value : (object instanceof Date ? new DateTime(((Date)value).getTime()) : (object instanceof Timestamp ? new DateTime(((Timestamp)value).getTime()) : (object instanceof Integer ? new DateTime(((Number)value).intValue()) : (object instanceof Long ? new DateTime(((Number)value).longValue()) : (object instanceof String ? (DefaultKt.getCurrentDialect() instanceof SQLiteDialect && this.time ? ColumnTypeKt.access$getSQLITE_DATE_TIME_STRING_FORMATTER$p().parseDateTime((String)value) : (DefaultKt.getCurrentDialect() instanceof SQLiteDialect ? ColumnTypeKt.access$getSQLITE_DATE_STRING_FORMATTER$p().parseDateTime((String)value) : value)) : ColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER$p().parseDateTime(value.toString()))))));
        Intrinsics.checkExpressionValueIsNotNull(object2, "when(value) {\n        is\u2026e(value.toString())\n    }");
        return object2;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof DateTime) {
            long millis = ((DateTime)value).getMillis();
            if (this.time) {
                return new Timestamp(millis);
            }
            return new Date(millis);
        }
        return value;
    }

    public final boolean getTime() {
        return this.time;
    }

    public DateColumnType(boolean time) {
        super(false, 1, null);
        this.time = time;
    }
}

