/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OrOp;
import org.jetbrains.exposed.sql.QueryBuilder;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/sql/ComparisonOp;", "Lorg/jetbrains/exposed/sql/Op;", "", "expr1", "Lorg/jetbrains/exposed/sql/Expression;", "expr2", "opSign", "", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/String;)V", "getExpr1", "()Lorg/jetbrains/exposed/sql/Expression;", "getExpr2", "getOpSign", "()Ljava/lang/String;", "toSQL", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed"})
public abstract class ComparisonOp
extends Op<Boolean> {
    @NotNull
    private final Expression<?> expr1;
    @NotNull
    private final Expression<?> expr2;
    @NotNull
    private final String opSign;

    @Override
    @NotNull
    public String toSQL(@NotNull QueryBuilder queryBuilder) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(queryBuilder, "queryBuilder");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        if (this.expr1 instanceof OrOp) {
            $receiver.append("(").append(this.expr1.toSQL(queryBuilder)).append(")");
        } else {
            $receiver.append(this.expr1.toSQL(queryBuilder));
        }
        $receiver.append(' ' + this.opSign + ' ');
        if (this.expr2 instanceof OrOp) {
            $receiver.append("(").append(this.expr2.toSQL(queryBuilder)).append(")");
        } else {
            $receiver.append(this.expr2.toSQL(queryBuilder));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final Expression<?> getExpr1() {
        return this.expr1;
    }

    @NotNull
    public final Expression<?> getExpr2() {
        return this.expr2;
    }

    @NotNull
    public final String getOpSign() {
        return this.opSign;
    }

    public ComparisonOp(@NotNull Expression<?> expr1, @NotNull Expression<?> expr2, @NotNull String opSign) {
        Intrinsics.checkParameterIsNotNull(expr1, "expr1");
        Intrinsics.checkParameterIsNotNull(expr2, "expr2");
        Intrinsics.checkParameterIsNotNull(opSign, "opSign");
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.opSign = opSign;
    }
}

