/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnKt;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u00104\u001a\u00020\u001f2\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0006\u00107\u001a\u00020\bJ\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0013\u00109\u001a\u00020:2\b\u00105\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020\u001fH\u0016J\r\u0010=\u001a\u00020:H\u0000\u00a2\u0006\u0002\b>J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0010\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020\bH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\u0004\u0018\u00010(8@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R \u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006D"}, d2={"Lorg/jetbrains/exposed/sql/Column;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "name", "", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;)V", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "dbDefaultValue", "Lorg/jetbrains/exposed/sql/Expression;", "getDbDefaultValue$exposed", "()Lorg/jetbrains/exposed/sql/Expression;", "setDbDefaultValue$exposed", "(Lorg/jetbrains/exposed/sql/Expression;)V", "ddl", "", "getDdl", "()Ljava/util/List;", "defaultValueFun", "Lkotlin/Function0;", "getDefaultValueFun$exposed", "()Lkotlin/jvm/functions/Function0;", "setDefaultValueFun$exposed", "(Lkotlin/jvm/functions/Function0;)V", "indexInPK", "", "getIndexInPK$exposed", "()Ljava/lang/Integer;", "setIndexInPK$exposed", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getName", "()Ljava/lang/String;", "onDelete", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getOnDelete$exposed", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "setOnDelete$exposed", "(Lorg/jetbrains/exposed/sql/ReferenceOption;)V", "referee", "getReferee", "()Lorg/jetbrains/exposed/sql/Column;", "setReferee", "(Lorg/jetbrains/exposed/sql/Column;)V", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "compareTo", "other", "createStatement", "descriptionDdl", "dropStatement", "equals", "", "", "hashCode", "isOneColumnPK", "isOneColumnPK$exposed", "modifyStatement", "toSQL", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "toString", "exposed"})
public final class Column<T>
extends ExpressionWithColumnType<T>
implements DdlAware,
Comparable<Column<?>> {
    @Nullable
    private Column<?> referee;
    @Nullable
    private ReferenceOption onDelete;
    @Nullable
    private Integer indexInPK;
    @Nullable
    private Function0<? extends T> defaultValueFun;
    @Nullable
    private Expression<T> dbDefaultValue;
    @NotNull
    private final Table table;
    @NotNull
    private final String name;
    @NotNull
    private final IColumnType columnType;

    @Nullable
    public final Column<?> getReferee() {
        return this.referee;
    }

    public final void setReferee(@Nullable Column<?> column) {
        this.referee = column;
    }

    @Nullable
    public final ReferenceOption getOnDelete$exposed() {
        ReferenceOption referenceOption = this.onDelete;
        if (referenceOption == null) {
            DatabaseDialect databaseDialect = DefaultKt.getCurrentDialectIfAvailable();
            referenceOption = databaseDialect != null ? databaseDialect.getDefaultReferenceOption() : null;
        }
        return referenceOption;
    }

    public final void setOnDelete$exposed(@Nullable ReferenceOption referenceOption) {
        this.onDelete = referenceOption;
    }

    @Nullable
    public final Integer getIndexInPK$exposed() {
        return this.indexInPK;
    }

    public final void setIndexInPK$exposed(@Nullable Integer n) {
        this.indexInPK = n;
    }

    @Nullable
    public final Function0<T> getDefaultValueFun$exposed() {
        return this.defaultValueFun;
    }

    public final void setDefaultValueFun$exposed(@Nullable Function0<? extends T> function0) {
        this.defaultValueFun = function0;
    }

    @Nullable
    public final Expression<T> getDbDefaultValue$exposed() {
        return this.dbDefaultValue;
    }

    public final void setDbDefaultValue$exposed(@Nullable Expression<T> expression) {
        this.dbDefaultValue = expression;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        boolean bl;
        Object object = other;
        if (!(object instanceof Column)) {
            object = null;
        }
        Column column = (Column)object;
        if (column != null) {
            Column column2;
            Column it = column2 = column;
            bl = Intrinsics.areEqual(it.table, this.table) && Intrinsics.areEqual(it.name, this.name) && Intrinsics.areEqual(it.getColumnType(), this.getColumnType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.table.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.table.getClass().getName() + '.' + this.name;
    }

    @Override
    @NotNull
    public String toSQL(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkParameterIsNotNull(queryBuilder, "queryBuilder");
        return TransactionManager.Companion.current().fullIdentity(this);
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<String> createStatement() {
        alterTablePrefix = "ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + " ADD";
        if (this.indexInPK == null) ** GOTO lbl-1000
        var3_2 = this.table.getColumns();
        var19_3 = this.indexInPK;
        var4_4 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        $receiver$iv$iv$iv = $receiver$iv$iv;
        var7_7 = $receiver$iv$iv$iv.iterator();
        while (var7_7.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var7_7.next();
            it = (Column)element$iv$iv;
            if (this.indexInPK == null) continue;
            it$iv$iv = var12_11;
            destination$iv$iv.add(it$iv$iv);
        }
        var20_13 = (List)destination$iv$iv;
        if (Intrinsics.areEqual(var19_3, (Integer)CollectionsKt.max(var20_13))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = isLastColumnInPK = false;
        }
        columnDefinition = this.isOneColumnPK$exposed() != false && (DefaultKt.getCurrentDialect() instanceof H2Dialect != false || DefaultKt.getCurrentDialect() instanceof SQLiteDialect != false) ? StringsKt.removeSuffix(this.descriptionDdl(), (CharSequence)" PRIMARY KEY") : (this.isOneColumnPK$exposed() == false && isLastColumnInPK != false && DefaultKt.getCurrentDialect() instanceof H2Dialect == false ? ", ADD " + this.table.primaryKeyConstraint$exposed() : this.descriptionDdl());
        addConstr = isLastColumnInPK != false && DefaultKt.getCurrentDialect() instanceof H2Dialect != false ? "" + alterTablePrefix + ' ' + this.table.primaryKeyConstraint$exposed() : null;
        return CollectionsKt.listOfNotNull(new String[]{"" + alterTablePrefix + ' ' + columnDefinition, addConstr});
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.listOf("ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + ' ' + DefaultKt.getCurrentDialect().modifyColumn(this));
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        Transaction transaction;
        Transaction it = transaction = TransactionManager.Companion.current();
        return CollectionsKt.listOf("ALTER TABLE " + it.identity(this.table) + " DROP COLUMN " + it.identity(this));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isOneColumnPK$exposed() {
        Object object;
        block2: {
            void var2_2;
            Iterable $receiver$iv = this.table.getColumns();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                Column it = (Column)element$iv;
                if (!(it.indexInPK != null)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var2_2;
        }
        return Intrinsics.areEqual((Column)object, this);
    }

    @NotNull
    public final String descriptionDdl() {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        Transaction tr = TransactionManager.Companion.current();
        $receiver.append(tr.identity(this));
        $receiver.append(" ");
        boolean isPKColumn = this.indexInPK != null;
        IColumnType colType = this.getColumnType();
        if (DefaultKt.getCurrentDialect() instanceof SQLiteDialect && this.isOneColumnPK$exposed() && ColumnTypeKt.isAutoInc(colType)) {
            $receiver.append(StringsKt.removeSuffix(colType.sqlType(), (CharSequence)" AUTO_INCREMENT"));
        } else {
            $receiver.append(colType.sqlType());
        }
        Expression<T> _dbDefaultValue = this.dbDefaultValue;
        if (!isPKColumn && _dbDefaultValue != null) {
            String expressionSQL = DefaultKt.getCurrentDialect().getDataTypeProvider().processForDefaultValue(_dbDefaultValue);
            if (!DefaultKt.getCurrentDialect().isAllowedAsColumnDefault(_dbDefaultValue)) {
                String clientDefault = this.defaultValueFun != null ? " Expression will be evaluated on client." : (!colType.getNullable() ? " Column will be created with NULL marker." : "");
                SQLLogKt.getExposedLogger().error("" + DefaultKt.getCurrentDialect().getName() + ' ' + tr.getDb().getVersion() + " doesn't support expression '" + expressionSQL + "' as default value." + clientDefault);
            } else {
                $receiver.append(" DEFAULT " + expressionSQL);
            }
        }
        if (colType.getNullable() || _dbDefaultValue != null && this.defaultValueFun == null && !DefaultKt.getCurrentDialect().isAllowedAsColumnDefault(_dbDefaultValue)) {
            $receiver.append(" NULL");
        } else if (!isPKColumn) {
            $receiver.append(" NOT NULL");
        }
        if (this.isOneColumnPK$exposed()) {
            $receiver.append(" PRIMARY KEY");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public int compareTo(@NotNull Column<?> other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return ColumnKt.access$getComparator$p().compare(this, other);
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IColumnType getColumnType() {
        return this.columnType;
    }

    public Column(@NotNull Table table, @NotNull String name, @NotNull IColumnType columnType) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(columnType, "columnType");
        this.table = table;
        this.name = name;
        this.columnType = columnType;
    }
}

