/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.CaseWhen;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.QueryBuilder;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u0002H\u00012\b\u0012\u0004\u0012\u0002H\u00020\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/sql/CaseWhenElse;", "T", "R", "Lorg/jetbrains/exposed/sql/Expression;", "caseWhen", "Lorg/jetbrains/exposed/sql/CaseWhen;", "elseResult", "(Lorg/jetbrains/exposed/sql/CaseWhen;Lorg/jetbrains/exposed/sql/Expression;)V", "getCaseWhen", "()Lorg/jetbrains/exposed/sql/CaseWhen;", "getElseResult", "()Lorg/jetbrains/exposed/sql/Expression;", "toSQL", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed"})
public final class CaseWhenElse<T, R extends T>
extends Expression<R> {
    @NotNull
    private final CaseWhen<T> caseWhen;
    @NotNull
    private final Expression<R> elseResult;

    @Override
    @NotNull
    public String toSQL(@NotNull QueryBuilder queryBuilder) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(queryBuilder, "queryBuilder");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("CASE");
        if (this.caseWhen.getValue() != null) {
            $receiver.append(' ' + this.caseWhen.getValue().toSQL(queryBuilder));
        }
        for (Pair<Expression<Boolean>, Expression<T>> pair : this.caseWhen.getCases()) {
            Expression<Boolean> first2 = pair.component1();
            Expression<T> second = pair.component2();
            $receiver.append(" WHEN " + first2.toSQL(queryBuilder) + " THEN " + second.toSQL(queryBuilder));
        }
        $receiver.append(" ELSE " + this.elseResult.toSQL(queryBuilder) + " END");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final CaseWhen<T> getCaseWhen() {
        return this.caseWhen;
    }

    @NotNull
    public final Expression<R> getElseResult() {
        return this.elseResult;
    }

    public CaseWhenElse(@NotNull CaseWhen<T> caseWhen, @NotNull Expression<R> elseResult) {
        Intrinsics.checkParameterIsNotNull(caseWhen, "caseWhen");
        Intrinsics.checkParameterIsNotNull(elseResult, "elseResult");
        this.caseWhen = caseWhen;
        this.elseResult = elseResult;
    }
}

