/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/exposed/sql/BooleanColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "sqlType", "valueFromDB", "", "(Ljava/lang/Object;)Ljava/lang/Boolean;", "exposed"})
public final class BooleanColumnType
extends ColumnType {
    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().booleanType();
    }

    @Override
    @NotNull
    public Boolean valueFromDB(@NotNull Object value) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof Number) {
            bl = ((Number)value).longValue() != 0L;
        } else if (object instanceof String) {
            bl = DefaultKt.getCurrentDialect().getDataTypeProvider().booleanFromStringToBoolean((String)value);
        } else {
            String string = value.toString();
            bl = Boolean.parseBoolean(string);
        }
        return bl;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return DefaultKt.getCurrentDialect().getDataTypeProvider().booleanToStatementString((Boolean)value);
    }

    public BooleanColumnType() {
        super(false, 1, null);
    }
}

