/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.sql.rowset.serial.SerialBlob;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/BlobColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "setParameter", "", "stmt", "Ljava/sql/PreparedStatement;", "sqlType", "valueFromDB", "exposed"})
public final class BlobColumnType
extends ColumnType {
    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().blobType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return "?";
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Blob blob;
        Intrinsics.checkParameterIsNotNull(rs, "rs");
        if (DefaultKt.getCurrentDialect().getDataTypeProvider().getBlobAsStream()) {
            SerialBlob serialBlob;
            byte[] byArray = rs.getBytes(index);
            if (byArray != null) {
                byte[] byArray2;
                byte[] it = byArray2 = byArray;
                serialBlob = new SerialBlob(it);
            } else {
                serialBlob = null;
            }
            blob = serialBlob;
        } else {
            blob = rs.getBlob(index);
        }
        return blob;
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Blob blob;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof Blob) {
            blob = (Blob)value;
        } else if (object instanceof InputStream) {
            blob = new SerialBlob(ByteStreamsKt.readBytes$default((InputStream)value, 0, 1, null));
        } else if (object instanceof byte[]) {
            blob = new SerialBlob((byte[])value);
        } else {
            String string = "Unknown type for blob column :" + value.getClass();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return blob;
    }

    @Override
    public void setParameter(@NotNull PreparedStatement stmt, int index, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(stmt, "stmt");
        if (DefaultKt.getCurrentDialect().getDataTypeProvider().getBlobAsStream() && value instanceof InputStream) {
            stmt.setBinaryStream(index, (InputStream)value, ((InputStream)value).available());
        } else if (value == null) {
            stmt.setNull(index, -4);
        } else {
            super.setParameter(stmt, index, value);
        }
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (DefaultKt.getCurrentDialect().getDataTypeProvider().getBlobAsStream()) {
            Object object2 = value;
            if (!(object2 instanceof Blob)) {
                object2 = null;
            }
            if ((object = (Blob)object2) == null || (object = object.getBinaryStream()) == null) {
                object = value;
            }
        } else {
            object = value;
        }
        return object;
    }

    public BlobColumnType() {
        super(false, 1, null);
    }
}

