/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.EntityIDColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IntegerColumnType;
import org.jetbrains.exposed.sql.LongColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0011\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0001H\u0002J#\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0001J\b\u0010!\u001a\u00020\u0005H\u0016J\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0015\u0010#\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0001J\u0013\u0010$\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\rX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/exposed/sql/AutoIncColumnType;", "Lorg/jetbrains/exposed/sql/IColumnType;", "delegate", "Lorg/jetbrains/exposed/sql/ColumnType;", "_autoincSeq", "", "(Lorg/jetbrains/exposed/sql/ColumnType;Ljava/lang/String;)V", "autoincSeq", "getAutoincSeq", "()Ljava/lang/String;", "getDelegate", "()Lorg/jetbrains/exposed/sql/ColumnType;", "nullable", "", "getNullable", "()Z", "setNullable", "(Z)V", "nonNullValueToString", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "resolveAutIncType", "columnType", "setParameter", "", "stmt", "Ljava/sql/PreparedStatement;", "sqlType", "valueFromDB", "valueToDB", "valueToString", "exposed"})
public final class AutoIncColumnType
implements IColumnType {
    @NotNull
    private final ColumnType delegate;
    private final String _autoincSeq;

    @Nullable
    public final String getAutoincSeq() {
        return DefaultKt.getCurrentDialect().getNeedsSequenceToAutoInc() ? this._autoincSeq : null;
    }

    private final String resolveAutIncType(IColumnType columnType) {
        String string;
        IColumnType iColumnType = columnType;
        if (iColumnType instanceof EntityIDColumnType) {
            string = this.resolveAutIncType(((EntityIDColumnType)columnType).getIdColumn().getColumnType());
        } else if (iColumnType instanceof IntegerColumnType) {
            string = DefaultKt.getCurrentDialect().getDataTypeProvider().shortAutoincType();
        } else if (iColumnType instanceof LongColumnType) {
            string = DefaultKt.getCurrentDialect().getDataTypeProvider().longAutoincType();
        } else {
            String string2 = "Unsupported type " + this.delegate + " for auto-increment";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @Override
    @NotNull
    public String sqlType() {
        return this.resolveAutIncType(this.delegate);
    }

    @NotNull
    public final ColumnType getDelegate() {
        return this.delegate;
    }

    public AutoIncColumnType(@NotNull ColumnType delegate, @NotNull String _autoincSeq) {
        Intrinsics.checkParameterIsNotNull(delegate, "delegate");
        Intrinsics.checkParameterIsNotNull(_autoincSeq, "_autoincSeq");
        this.delegate = delegate;
        this._autoincSeq = _autoincSeq;
    }

    @Override
    public boolean getNullable() {
        return this.delegate.getNullable();
    }

    @Override
    public void setNullable(boolean bl) {
        this.delegate.setNullable(bl);
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return this.delegate.nonNullValueToString(value);
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return this.delegate.notNullValueToDB(value);
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkParameterIsNotNull(rs, "rs");
        return this.delegate.readObject(rs, index);
    }

    @Override
    public void setParameter(@NotNull PreparedStatement stmt, int index, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(stmt, "stmt");
        this.delegate.setParameter(stmt, index, value);
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return this.delegate.valueFromDB(value);
    }

    @Override
    @Nullable
    public Object valueToDB(@Nullable Object value) {
        return this.delegate.valueToDB(value);
    }

    @Override
    @NotNull
    public String valueToString(@Nullable Object value) {
        return this.delegate.valueToString(value);
    }
}

