/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityChange;
import org.jetbrains.exposed.dao.EntityChangeType;
import org.jetbrains.exposed.dao.EntityClass;
import org.jetbrains.exposed.dao.EntityHook;
import org.jetbrains.exposed.dao.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.IterableExKt;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.BatchInsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0002J'\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0086\u0002JA\u0010\u0018\u001a\u00020\u0019\"\u000e\b\u0002\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00042\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015H\u0086\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/dao/InnerTableLink;", "ID", "", "Target", "Lorg/jetbrains/exposed/dao/Entity;", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "target", "Lorg/jetbrains/exposed/dao/EntityClass;", "(Lorg/jetbrains/exposed/sql/Table;Lorg/jetbrains/exposed/dao/EntityClass;)V", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "getTarget", "()Lorg/jetbrains/exposed/dao/EntityClass;", "getSourceRefColumn", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/dao/EntityID;", "o", "getTargetRefColumn", "getValue", "Lorg/jetbrains/exposed/sql/SizedIterable;", "desc", "Lkotlin/reflect/KProperty;", "setValue", "", "SrcID", "value", "exposed"})
public final class InnerTableLink<ID extends Comparable<? super ID>, Target extends Entity<ID>> {
    @NotNull
    private final Table table;
    @NotNull
    private final EntityClass<ID, Target> target;

    private final Column<EntityID<?>> getSourceRefColumn(Entity<?> o) {
        Object v1;
        Object v0;
        block4: {
            Iterable $receiver$iv = this.table.getColumns();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                Column it = (Column)element$iv;
                if (!Intrinsics.areEqual(it.getReferee(), o.getKlass().getTable().getId())) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = v1 = !found$iv ? null : single$iv;
        }
        if (!(v0 instanceof Column)) {
            v1 = null;
        }
        Column column = v1;
        if (column == null) {
            String string = "Table does not reference source";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Column sourceRefColumn = column;
        return sourceRefColumn;
    }

    /*
     * WARNING - void declaration
     */
    private final Column<EntityID<?>> getTargetRefColumn() {
        Object object;
        Object object2;
        block4: {
            void var3_2;
            Iterable $receiver$iv = this.table.getColumns();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                Column it = (Column)element$iv;
                if (!Intrinsics.areEqual(it.getReferee(), this.target.getTable().getId())) continue;
                if (found$iv) {
                    object2 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object2 = object = !found$iv ? null : var3_2;
        }
        if (!(object2 instanceof Column)) {
            object = null;
        }
        Column column = (Column)object;
        if (column == null) {
            String string = "Table does not reference target";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Column sourceRefColumn = column;
        return sourceRefColumn;
    }

    @NotNull
    public final SizedIterable<Target> getValue(@NotNull Entity<?> o, @NotNull KProperty<?> desc) {
        Intrinsics.checkParameterIsNotNull(o, "o");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        if (o.getId().get_value() == null) {
            return IterableExKt.emptySized();
        }
        Column<EntityID<?>> sourceRefColumn = this.getSourceRefColumn(o);
        ColumnSet columnSet = this.target.getDependsOnTables();
        if (!(columnSet instanceof Join)) {
            columnSet = null;
        }
        Join join2 = (Join)columnSet;
        boolean alreadyInJoin = join2 != null ? join2.alreadyInJoin(this.table) : false;
        ColumnSet entityTables = alreadyInJoin ? this.target.getDependsOnTables() : (ColumnSet)ColumnSet.join$default(this.target.getDependsOnTables(), this.table, JoinType.INNER, this.target.getTable().getId(), this.getTargetRefColumn(), null, 16, null);
        List<Column<EntityID<?>>> columns2 = CollectionsKt.plus((Collection)CollectionsKt.distinct((Iterable)CollectionsKt.minus((Iterable)CollectionsKt.plus((Collection)this.target.getDependsOnColumns(), (Iterable)(!alreadyInJoin ? this.table.getColumns() : CollectionsKt.emptyList())), sourceRefColumn)), sourceRefColumn);
        Function0 query2 = new Function0<SizedIterable<? extends Target>>(this, entityTables, columns2, sourceRefColumn, o){
            final /* synthetic */ InnerTableLink this$0;
            final /* synthetic */ ColumnSet $entityTables;
            final /* synthetic */ List $columns;
            final /* synthetic */ Column $sourceRefColumn;
            final /* synthetic */ Entity $o;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SizedIterable<Target> invoke() {
                void $receiver;
                void $receiver$iv;
                FieldSet fieldSet = this.$entityTables.slice(this.$columns);
                EntityClass<ID, Target> entityClass = this.this$0.getTarget();
                SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
                Query query2 = $receiver$iv;
                Op<Boolean> op = $receiver.eq((ExpressionWithColumnType)this.$sourceRefColumn, this.$o.getId());
                query2 = QueriesKt.select((FieldSet)((Object)query2), op);
                return entityClass.wrapRows(query2);
            }
            {
                this.this$0 = innerTableLink;
                this.$entityTables = columnSet;
                this.$columns = list;
                this.$sourceRefColumn = column;
                this.$o = entity;
                super(0);
            }
        };
        return TransactionManager.Companion.current().getEntityCache().getOrPutReferrers(o.getId(), sourceRefColumn, query2);
    }

    /*
     * WARNING - void declaration
     */
    public final <SrcID extends Comparable<? super SrcID>> void setValue(@NotNull Entity<SrcID> o, @NotNull KProperty<?> desc, @NotNull SizedIterable<? extends Target> value) {
        EntityClass targetClass;
        EntityID it;
        Iterable $receiver$iv$iv;
        Object object;
        EntityID it2;
        Object object2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(o, "o");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Column<EntityID<SrcID>> sourceRefColumn = this.getSourceRefColumn(o);
        Column<EntityID<?>> targetRefColumn = this.getTargetRefColumn();
        EntityCache entityCache = TransactionManager.Companion.current().getEntityCache();
        entityCache.flush();
        SizedIterable<Target> oldValue = this.getValue(o, desc);
        Iterable iterable = $receiver$iv = (Iterable)oldValue;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            Entity entity = (Entity)item$iv$iv;
            object2 = destination$iv$iv;
            object = ((Entity)((Object)it2)).getId();
            object2.add(object);
        }
        Set existingIds = CollectionsKt.toSet((List)destination$iv$iv);
        entityCache.clearReferrersCache();
        Iterable $receiver$iv2 = value;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Entity $i$a$1$map = (Entity)item$iv$iv;
            object2 = destination$iv$iv2;
            object = ((Entity)((Object)it)).getId();
            object2.add(object);
        }
        List targetIds = (List)destination$iv$iv2;
        QueriesKt.deleteWhere(this.table, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)new Function1<SqlExpressionBuilder, Op<Boolean>>(sourceRefColumn, o, targetRefColumn, targetIds){
            final /* synthetic */ Column $sourceRefColumn;
            final /* synthetic */ Entity $o;
            final /* synthetic */ Column $targetRefColumn;
            final /* synthetic */ List $targetIds;

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                return OpKt.and($receiver.eq((ExpressionWithColumnType)this.$sourceRefColumn, this.$o.getId()), (Expression<Boolean>)$receiver.notInList(this.$targetRefColumn, this.$targetIds));
            }
            {
                this.$sourceRefColumn = column;
                this.$o = entity;
                this.$targetRefColumn = column2;
                this.$targetIds = list;
                super(1);
            }
        });
        $receiver$iv2 = targetIds;
        object2 = this.table;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (EntityID)element$iv$iv;
            if (!(!existingIds.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        object = (List)destination$iv$iv2;
        QueriesKt.batchInsert$default((Table)object2, (Iterable)object, false, new Function2<BatchInsertStatement, EntityID<ID>, Unit>(o, sourceRefColumn, targetRefColumn){
            final /* synthetic */ Entity $o;
            final /* synthetic */ Column $sourceRefColumn;
            final /* synthetic */ Column $targetRefColumn;

            public final void invoke(@NotNull BatchInsertStatement $receiver, @NotNull EntityID<ID> targetId) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Intrinsics.checkParameterIsNotNull(targetId, "targetId");
                $receiver.set(this.$sourceRefColumn, this.$o.getId());
                $receiver.set(this.$targetRefColumn, targetId);
            }
            {
                this.$o = entity;
                this.$sourceRefColumn = column;
                this.$targetRefColumn = column2;
                super(2);
            }
        }, 2, null);
        EntityHook.INSTANCE.registerChange(new EntityChange(o.getKlass(), o.getId(), EntityChangeType.Updated));
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)value);
        if (entity == null) {
            entity = (Entity)CollectionsKt.firstOrNull((Iterable)oldValue);
        }
        EntityClass entityClass = targetClass = entity != null ? entity.getKlass() : null;
        if (targetClass != null) {
            Iterable $receiver$iv3 = SetsKt.plus(existingIds, targetIds);
            for (Object element$iv : $receiver$iv3) {
                it2 = (EntityID)element$iv;
                EntityHook.INSTANCE.registerChange(new EntityChange(targetClass, it2, EntityChangeType.Updated));
            }
        }
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final EntityClass<ID, Target> getTarget() {
        return this.target;
    }

    public InnerTableLink(@NotNull Table table, @NotNull EntityClass<ID, ? extends Target> target) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.table = table;
        this.target = target;
    }
}

