/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileChannelOutputStream;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathEncrypt;
import org.h2.store.fs.FileUtils;
import org.h2.util.Tool;

public class ChangeFileEncryption
extends Tool {
    private String directory;
    private String cipherType;
    private byte[] decrypt;
    private byte[] encrypt;
    private byte[] decryptKey;
    private byte[] encryptKey;

    public static void main(String ... stringArray) throws SQLException {
        new ChangeFileEncryption().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        String string3 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-dir")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-cipher")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-db")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-decrypt")) {
                cArray = stringArray[++i].toCharArray();
                continue;
            }
            if (string4.equals("-encrypt")) {
                cArray2 = stringArray[++i].toCharArray();
                continue;
            }
            if (string4.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string4.equals("-help") || string4.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string4);
        }
        if (cArray2 == null && cArray == null || string2 == null) {
            this.showUsage();
            throw new SQLException("Encryption or decryption password not set, or cipher not set");
        }
        try {
            this.process(string, string3, string2, cArray, cArray2, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private static byte[] getFileEncryptionKey(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return SHA256.getKeyPasswordHash("file", cArray);
    }

    public static void execute(String string, String string2, String string3, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        try {
            new ChangeFileEncryption().process(string, string2, string3, cArray, cArray2, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private void process(String string, String string2, String string3, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        string = FileLister.getDir(string);
        ChangeFileEncryption changeFileEncryption = new ChangeFileEncryption();
        if (cArray2 != null) {
            for (char c : cArray2) {
                if (c != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
            changeFileEncryption.encryptKey = FilePathEncrypt.getPasswordBytes(cArray2);
            changeFileEncryption.encrypt = ChangeFileEncryption.getFileEncryptionKey(cArray2);
        }
        if (cArray != null) {
            changeFileEncryption.decryptKey = FilePathEncrypt.getPasswordBytes(cArray);
            changeFileEncryption.decrypt = ChangeFileEncryption.getFileEncryptionKey(cArray);
        }
        changeFileEncryption.out = this.out;
        changeFileEncryption.directory = string;
        changeFileEncryption.cipherType = string3;
        Object object = FileLister.getDatabaseFiles(string, string2, true);
        FileLister.tryUnlockDatabase((List<String>)object, "encryption");
        object = FileLister.getDatabaseFiles(string, string2, false);
        if (((ArrayList)object).size() == 0 && !bl) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            String string4 = (String)iterator2.next();
            String string5 = string + "/temp.db";
            FileUtils.delete(string5);
            FileUtils.move(string4, string5);
            FileUtils.move(string5, string4);
        }
        iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            String string6 = (String)iterator2.next();
            if (FileUtils.isDirectory(string6)) continue;
            changeFileEncryption.process(string6, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string, boolean bl) {
        if (string.endsWith(".mv.db")) {
            try {
                this.copy(string, bl);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, "Error encrypting / decrypting file " + string);
            }
            return;
        }
        FileStore fileStore = this.decrypt == null ? FileStore.open(null, string, "r") : FileStore.open(null, string, "r", this.cipherType, this.decrypt);
        try {
            fileStore.init();
            this.copy(string, fileStore, this.encrypt, bl);
        }
        finally {
            fileStore.closeSilently();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String string, boolean bl) throws IOException {
        if (FileUtils.isDirectory(string)) {
            return;
        }
        FileChannel fileChannel = FilePath.get(string).open("r");
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        String string2 = this.directory + "/temp.db";
        try {
            long l;
            if (this.decryptKey != null) {
                fileChannel = new FilePathEncrypt.FileEncrypt(string, this.decryptKey, fileChannel);
            }
            FileChannelInputStream fileChannelInputStream = new FileChannelInputStream(fileChannel, true);
            FileUtils.delete(string2);
            abstractInterruptibleChannel = FilePath.get(string2).open("rw");
            if (this.encryptKey != null) {
                abstractInterruptibleChannel = new FilePathEncrypt.FileEncrypt(string2, this.encryptKey, (FileChannel)abstractInterruptibleChannel);
            }
            FileChannelOutputStream fileChannelOutputStream = new FileChannelOutputStream((FileChannel)abstractInterruptibleChannel, true);
            byte[] byArray = new byte[4096];
            long l2 = l = fileChannel.size();
            long l3 = System.nanoTime();
            while (l > 0L) {
                if (!bl && System.nanoTime() - l3 > TimeUnit.SECONDS.toNanos(1L)) {
                    this.out.println(string + ": " + (100L - 100L * l / l2) + "%");
                    l3 = System.nanoTime();
                }
                int n = (int)Math.min((long)byArray.length, l);
                n = ((InputStream)fileChannelInputStream).read(byArray, 0, n);
                ((OutputStream)fileChannelOutputStream).write(byArray, 0, n);
                l -= (long)n;
            }
            ((InputStream)fileChannelInputStream).close();
            ((OutputStream)fileChannelOutputStream).close();
        }
        finally {
            fileChannel.close();
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
        FileUtils.delete(string);
        FileUtils.move(string2, string);
    }

    private void copy(String string, FileStore fileStore, byte[] byArray, boolean bl) {
        long l;
        if (FileUtils.isDirectory(string)) {
            return;
        }
        String string2 = this.directory + "/temp.db";
        FileUtils.delete(string2);
        FileStore fileStore2 = byArray == null ? FileStore.open(null, string2, "rw") : FileStore.open(null, string2, "rw", this.cipherType, byArray);
        fileStore2.init();
        byte[] byArray2 = new byte[4096];
        long l2 = l = fileStore.length() - 48L;
        fileStore.seek(48L);
        fileStore2.seek(48L);
        long l3 = System.nanoTime();
        while (l > 0L) {
            if (!bl && System.nanoTime() - l3 > TimeUnit.SECONDS.toNanos(1L)) {
                this.out.println(string + ": " + (100L - 100L * l / l2) + "%");
                l3 = System.nanoTime();
            }
            int n = (int)Math.min((long)byArray2.length, l);
            fileStore.readFully(byArray2, 0, n);
            fileStore2.write(byArray2, 0, n);
            l -= (long)n;
        }
        fileStore.close();
        fileStore2.close();
        FileUtils.delete(string);
        FileUtils.move(string2, string);
    }
}

