/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class Data {
    public static final int LENGTH_INT = 4;
    private static final int LENGTH_LONG = 8;
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int LOCAL_TIME = 132;
    private static final int LOCAL_DATE = 133;
    private static final int LOCAL_TIMESTAMP = 134;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final boolean STORE_LOCAL_TIME = false;
    private byte[] data;
    private int pos;
    private final DataHandler handler;

    private Data(DataHandler dataHandler, byte[] byArray) {
        this.handler = dataHandler;
        this.data = byArray;
    }

    public void setInt(int n, int n2) {
        byte[] byArray = this.data;
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public void writeInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos] = (byte)(n >> 24);
        byArray[this.pos + 1] = (byte)(n >> 16);
        byArray[this.pos + 2] = (byte)(n >> 8);
        byArray[this.pos + 3] = (byte)n;
        this.pos += 4;
    }

    public int readInt() {
        byte[] byArray = this.data;
        int n = (byArray[this.pos] << 24) + ((byArray[this.pos + 1] & 0xFF) << 16) + ((byArray[this.pos + 2] & 0xFF) << 8) + (byArray[this.pos + 3] & 0xFF);
        this.pos += 4;
        return n;
    }

    public static int getStringLen(String string) {
        int n = string.length();
        return Data.getStringWithoutLengthLen(string, n) + Data.getVarIntLen(n);
    }

    private static int getStringWithoutLengthLen(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0800') {
                n2 += 2;
                continue;
            }
            if (c < '\u0080') continue;
            ++n2;
        }
        return n + n2;
    }

    public String readString() {
        int n = this.readVarInt();
        return this.readString(n);
    }

    private String readString(int n) {
        byte[] byArray = this.data;
        int n2 = this.pos;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n3;
            cArray[i] = (n3 = byArray[n2++] & 0xFF) < 128 ? (char)n3 : (n3 >= 224 ? (char)(((n3 & 0xF) << 12) + ((byArray[n2++] & 0x3F) << 6) + (byArray[n2++] & 0x3F)) : (char)(((n3 & 0x1F) << 6) + (byArray[n2++] & 0x3F)));
        }
        this.pos = n2;
        return new String(cArray);
    }

    public void writeString(String string) {
        int n = string.length();
        this.writeVarInt(n);
        this.writeStringWithoutLength(string, n);
    }

    private void writeStringWithoutLength(String string, int n) {
        int n2 = this.pos;
        byte[] byArray = this.data;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(c >> 6 & 0x3F);
                byArray[n2++] = (byte)(c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(c & 0x3F);
        }
        this.pos = n2;
    }

    private void writeStringWithoutLength(char[] cArray, int n) {
        int n2 = this.pos;
        byte[] byArray = this.data;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(c >> 6 & 0x3F);
                byArray[n2++] = (byte)(c & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c >> 6);
            byArray[n2++] = (byte)(c & 0x3F);
        }
        this.pos = n2;
    }

    public static Data create(DataHandler dataHandler, int n) {
        return new Data(dataHandler, new byte[n]);
    }

    public static Data create(DataHandler dataHandler, byte[] byArray) {
        return new Data(dataHandler, byArray);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void write(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.data, this.pos, n2);
        this.pos += n2;
    }

    public void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public void writeByte(byte by) {
        this.data[this.pos++] = by;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public void writeValue(Value value) {
        int n = this.pos;
        if (value == ValueNull.INSTANCE) {
            this.data[this.pos++] = 0;
            return;
        }
        int n2 = value.getType();
        switch (n2) {
            case 1: {
                this.writeByte((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                this.writeByte((byte)n2);
                this.writeByte(value.getByte());
                break;
            }
            case 3: {
                this.writeByte((byte)n2);
                this.writeShortInt(value.getShort());
                break;
            }
            case 4: {
                int n3 = value.getInt();
                if (n3 < 0) {
                    this.writeByte((byte)66);
                    this.writeVarInt(-n3);
                    break;
                }
                if (n3 < 16) {
                    this.writeByte((byte)(32 + n3));
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(n3);
                break;
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    this.writeByte((byte)67);
                    this.writeVarLong(-l);
                    break;
                }
                if (l < 8L) {
                    this.writeByte((byte)(48L + l));
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarLong(l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    this.writeByte((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    this.writeByte((byte)57);
                    break;
                }
                int n4 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n5 = bigInteger.bitLength();
                if (n5 <= 63) {
                    if (n4 == 0) {
                        this.writeByte((byte)58);
                        this.writeVarLong(bigInteger.longValue());
                        break;
                    }
                    this.writeByte((byte)59);
                    this.writeVarInt(n4);
                    this.writeVarLong(bigInteger.longValue());
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(n4);
                byte[] byArray = bigInteger.toByteArray();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 9: {
                this.writeByte((byte)n2);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
                break;
            }
            case 10: {
                this.writeByte((byte)n2);
                long l = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                this.writeVarLong(l / 60000L);
                break;
            }
            case 11: {
                Timestamp timestamp = value.getTimestamp();
                this.writeByte((byte)n2);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(timestamp));
                this.writeVarInt(timestamp.getNanos() % 1000000);
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                this.writeByte((byte)n2);
                this.writeVarLong(valueTimestampTimeZone.getDateValue());
                this.writeVarLong(valueTimestampTimeZone.getTimeNanos());
                this.writeVarInt(valueTimestampTimeZone.getTimeZoneOffsetMins());
                break;
            }
            case 19: 
            case 22: {
                this.writeByte((byte)n2);
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                this.writeVarInt(n6);
                this.write(byArray, 0, n6);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n7 = byArray.length;
                if (n7 < 32) {
                    this.writeByte((byte)(100 + n7));
                    this.write(byArray, 0, n7);
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(n7);
                this.write(byArray, 0, n7);
                break;
            }
            case 20: {
                this.writeByte((byte)n2);
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n8 = string.length();
                if (n8 < 32) {
                    this.writeByte((byte)(68 + n8));
                    this.writeStringWithoutLength(string, n8);
                    break;
                }
                this.writeByte((byte)n2);
                this.writeString(string);
                break;
            }
            case 14: 
            case 21: {
                this.writeByte((byte)n2);
                this.writeString(value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    this.writeByte((byte)61);
                    break;
                }
                long l = Double.doubleToLongBits(d);
                if (l == ValueDouble.ZERO_BITS) {
                    this.writeByte((byte)60);
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarLong(Long.reverse(l));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    this.writeByte((byte)63);
                    break;
                }
                int n9 = Float.floatToIntBits(f);
                if (n9 == ValueFloat.ZERO_BITS) {
                    this.writeByte((byte)62);
                    break;
                }
                this.writeByte((byte)n2);
                this.writeVarInt(Integer.reverse(n9));
                break;
            }
            case 15: 
            case 16: {
                this.writeByte((byte)n2);
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(this.handler);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n10 = -1;
                        if (!valueLob.isLinkedToTable()) {
                            n10 = -2;
                        }
                        this.writeVarInt(n10);
                        this.writeVarInt(valueLob.getTableId());
                        this.writeVarInt(valueLob.getObjectId());
                        this.writeVarLong(valueLob.getPrecision());
                        this.writeByte((byte)(valueLob.isCompressed() ? 1 : 0));
                        if (n10 != -2) break;
                        this.writeString(valueLob.getFileName());
                        break;
                    }
                    this.writeVarInt(byArray.length);
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    this.writeVarInt(-3);
                    this.writeVarInt(valueLobDb.getTableId());
                    this.writeVarLong(valueLobDb.getLobId());
                    this.writeVarLong(valueLobDb.getPrecision());
                    break;
                }
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                this.writeByte((byte)n2);
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            case 18: {
                this.writeByte((byte)n2);
                try {
                    int n11;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n12 = resultSetMetaData.getColumnCount();
                    this.writeVarInt(n12);
                    for (n11 = 0; n11 < n12; ++n11) {
                        this.writeString(resultSetMetaData.getColumnName(n11 + 1));
                        this.writeVarInt(resultSetMetaData.getColumnType(n11 + 1));
                        this.writeVarInt(resultSetMetaData.getPrecision(n11 + 1));
                        this.writeVarInt(resultSetMetaData.getScale(n11 + 1));
                    }
                    while (resultSet.next()) {
                        this.writeByte((byte)1);
                        for (n11 = 0; n11 < n12; ++n11) {
                            int n13 = DataType.getValueTypeFromResultSet(resultSetMetaData, n11 + 1);
                            Value value3 = DataType.readValue(null, resultSet, n11 + 1, n13);
                            this.writeValue(value3);
                        }
                    }
                    this.writeByte((byte)0);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            default: {
                DbException.throwInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && this.pos - n != Data.getValueLen(value, this.handler)) {
            throw DbException.throwInternalError("value size error: got " + (this.pos - n) + " expected " + Data.getValueLen(value, this.handler));
        }
    }

    public Value readValue() {
        int n = this.data[this.pos++] & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 3: {
                return ValueShort.get(this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int n2 = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), n2));
            }
            case 6: {
                int n3 = this.readVarInt();
                int n4 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n4);
                this.read(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n3));
            }
            case 133: {
                return ValueDate.fromDateValue(this.readVarLong());
            }
            case 10: {
                long l = this.readVarLong() * 60000L;
                return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(l));
            }
            case 132: {
                long l = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTime.fromNanos(l);
            }
            case 9: {
                return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()));
            }
            case 134: {
                long l = this.readVarLong();
                long l2 = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTimestamp.fromDateValueAndNanos(l, l2);
            }
            case 11: {
                return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()), this.readVarInt());
            }
            case 24: {
                long l = this.readVarLong();
                long l3 = this.readVarLong();
                short s = (short)this.readVarInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l3, s);
            }
            case 12: {
                int n5 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n5);
                this.read(byArray, 0, n5);
                return ValueBytes.getNoCopy(byArray);
            }
            case 22: {
                int n6 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n6);
                this.read(byArray, 0, n6);
                return ValueGeometry.get(byArray);
            }
            case 19: {
                int n7 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n7);
                this.read(byArray, 0, n7);
                return ValueJavaObject.getNoCopy(null, byArray, this.handler);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int n8 = this.readVarInt();
                if (n8 >= 0) {
                    byte[] byArray = DataUtils.newBytes(n8);
                    this.read(byArray, 0, n8);
                    return ValueLobDb.createSmallLob(n, byArray);
                }
                if (n8 == -3) {
                    int n9 = this.readVarInt();
                    long l = this.readVarLong();
                    long l4 = this.readVarLong();
                    ValueLobDb valueLobDb = ValueLobDb.create(n, this.handler, n9, l, null, l4);
                    return valueLobDb;
                }
                int n10 = this.readVarInt();
                int n11 = this.readVarInt();
                long l = 0L;
                boolean bl = false;
                if (n8 == -1 || n8 == -2) {
                    l = this.readVarLong();
                    boolean bl2 = bl = this.readByte() == 1;
                }
                if (n8 == -2) {
                    String string = this.readString();
                    return ValueLob.openUnlinked(n, this.handler, n10, n11, l, bl, string);
                }
                return ValueLob.openLinked(n, this.handler, n10, n11, l, bl);
            }
            case 17: {
                int n12 = this.readVarInt();
                Value[] valueArray = new Value[n12];
                for (int i = 0; i < n12; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                simpleResultSet.setAutoClose(false);
                int n13 = this.readVarInt();
                for (int i = 0; i < n13; ++i) {
                    simpleResultSet.addColumn(this.readString(), this.readVarInt(), this.readVarInt(), this.readVarInt());
                }
                while (this.readByte() != 0) {
                    Object[] objectArray = new Object[n13];
                    for (int i = 0; i < n13; ++i) {
                        objectArray[i] = this.readValue().getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInt.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueLong.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n14 = n - 100;
            byte[] byArray = DataUtils.newBytes(n14);
            this.read(byArray, 0, n14);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueString.get(this.readString(n - 68));
        }
        throw DbException.get(90030, "type: " + n);
    }

    public int getValueLen(Value value) {
        return Data.getValueLen(value, this.handler);
    }

    public static int getValueLen(Value value, DataHandler dataHandler) {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                int n = value.getInt();
                if (n < 0) {
                    return 1 + Data.getVarIntLen(-n);
                }
                if (n < 16) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(n);
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    return 1 + Data.getVarLongLen(-l);
                }
                if (l < 8L) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(l);
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    return 1;
                }
                long l = Double.doubleToLongBits(d);
                if (l == ValueDouble.ZERO_BITS) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(Long.reverse(l));
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    return 1;
                }
                int n = Float.floatToIntBits(f);
                if (n == ValueFloat.ZERO_BITS) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(Integer.reverse(n));
            }
            case 13: {
                String string = value.getString();
                int n = string.length();
                if (n < 32) {
                    return 1 + Data.getStringWithoutLengthLen(string, n);
                }
                return 1 + Data.getStringLen(string);
            }
            case 14: 
            case 21: {
                return 1 + Data.getStringLen(value.getString());
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    return 1;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    return 1;
                }
                int n = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n2 = bigInteger.bitLength();
                if (n2 <= 63) {
                    if (n == 0) {
                        return 1 + Data.getVarLongLen(bigInteger.longValue());
                    }
                    return 1 + Data.getVarIntLen(n) + Data.getVarLongLen(bigInteger.longValue());
                }
                byte[] byArray = bigInteger.toByteArray();
                return 1 + Data.getVarIntLen(n) + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 9: {
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
            }
            case 10: {
                long l = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                return 1 + Data.getVarLongLen(l / 60000L);
            }
            case 11: {
                Timestamp timestamp = value.getTimestamp();
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(timestamp)) + Data.getVarIntLen(timestamp.getNanos() % 1000000);
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l = valueTimestampTimeZone.getDateValue();
                long l2 = valueTimestampTimeZone.getTimeNanos();
                short s = valueTimestampTimeZone.getTimeZoneOffsetMins();
                return 1 + Data.getVarLongLen(l) + Data.getVarLongLen(l2) + Data.getVarIntLen(s);
            }
            case 19: 
            case 22: {
                byte[] byArray = value.getBytesNoCopy();
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n = byArray.length;
                if (n < 32) {
                    return 1 + byArray.length;
                }
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 20: {
                return 17;
            }
            case 15: 
            case 16: {
                int n = 1;
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(dataHandler);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n3 = -1;
                        if (!valueLob.isLinkedToTable()) {
                            n3 = -2;
                        }
                        n += Data.getVarIntLen(n3);
                        n += Data.getVarIntLen(valueLob.getTableId());
                        n += Data.getVarIntLen(valueLob.getObjectId());
                        n += Data.getVarLongLen(valueLob.getPrecision());
                        ++n;
                        if (n3 == -2) {
                            n += Data.getStringLen(valueLob.getFileName());
                        }
                    } else {
                        n += Data.getVarIntLen(byArray.length);
                        n += byArray.length;
                    }
                } else {
                    ValueLobDb valueLobDb = (ValueLobDb)value;
                    byte[] byArray = valueLobDb.getSmall();
                    if (byArray == null) {
                        n += Data.getVarIntLen(-3);
                        n += Data.getVarIntLen(valueLobDb.getTableId());
                        n += Data.getVarLongLen(valueLobDb.getLobId());
                        n += Data.getVarLongLen(valueLobDb.getPrecision());
                    } else {
                        n += Data.getVarIntLen(byArray.length);
                        n += byArray.length;
                    }
                }
                return n;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                int n = 1 + Data.getVarIntLen(valueArray.length);
                for (Value value2 : valueArray) {
                    n += Data.getValueLen(value2, dataHandler);
                }
                return n;
            }
            case 18: {
                int n = 1;
                try {
                    int n4;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n5 = resultSetMetaData.getColumnCount();
                    n += Data.getVarIntLen(n5);
                    for (n4 = 0; n4 < n5; ++n4) {
                        n += Data.getStringLen(resultSetMetaData.getColumnName(n4 + 1));
                        n += Data.getVarIntLen(resultSetMetaData.getColumnType(n4 + 1));
                        n += Data.getVarIntLen(resultSetMetaData.getPrecision(n4 + 1));
                        n += Data.getVarIntLen(resultSetMetaData.getScale(n4 + 1));
                    }
                    while (resultSet.next()) {
                        ++n;
                        for (n4 = 0; n4 < n5; ++n4) {
                            int n6 = DataType.getValueTypeFromResultSet(resultSetMetaData, n4 + 1);
                            Value value3 = DataType.readValue(null, resultSet, n4 + 1, n6);
                            n += Data.getValueLen(value3, dataHandler);
                        }
                    }
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                return ++n;
            }
        }
        throw DbException.throwInternalError("type=" + value.getType());
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public void writeShortInt(int n) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n >> 8);
        byArray[this.pos++] = (byte)n;
    }

    public short readShortInt() {
        byte[] byArray = this.data;
        return (short)(((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF));
    }

    public void truncate(int n) {
        if (this.pos > n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, n);
            this.pos = n;
            this.data = byArray;
        }
    }

    private static int getVarIntLen(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int n) {
        while ((n & 0xFFFFFF80) != 0) {
            this.data[this.pos++] = (byte)(0x80 | n & 0x7F);
            n >>>= 7;
        }
        this.data[this.pos++] = (byte)n;
    }

    public int readVarInt() {
        byte by = this.data[this.pos];
        if (by >= 0) {
            ++this.pos;
            return by;
        }
        return this.readVarIntRest(by);
    }

    private int readVarIntRest(int n) {
        int n2 = n & 0x7F;
        n = this.data[this.pos + 1];
        if (n >= 0) {
            this.pos += 2;
            return n2 | n << 7;
        }
        n2 |= (n & 0x7F) << 7;
        n = this.data[this.pos + 2];
        if (n >= 0) {
            this.pos += 3;
            return n2 | n << 14;
        }
        n2 |= (n & 0x7F) << 14;
        n = this.data[this.pos + 3];
        if (n >= 0) {
            this.pos += 4;
            return n2 | n << 21;
        }
        this.pos += 5;
        return n2 |= (n & 0x7F) << 21 | this.data[this.pos + 4] << 28;
    }

    public static int getVarLongLen(long l) {
        int n = 1;
        while ((l >>>= 7) != 0L) {
            ++n;
        }
        return n;
    }

    public void writeVarLong(long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.pos++] = (byte)(l & 0x7FL | 0x80L);
            l >>>= 7;
        }
        this.data[this.pos++] = (byte)l;
    }

    public long readVarLong() {
        long l;
        if ((l = (long)this.data[this.pos++]) >= 0L) {
            return l;
        }
        l &= 0x7FL;
        int n = 7;
        while (true) {
            long l2 = this.data[this.pos++];
            l |= (l2 & 0x7FL) << n;
            if (l2 >= 0L) {
                return l;
            }
            n += 7;
        }
    }

    public void checkCapacity(int n) {
        if (this.pos + n >= this.data.length) {
            this.expand(n);
        }
    }

    private void expand(int n) {
        byte[] byArray = DataUtils.newBytes((this.data.length + n) * 2);
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    public void fillAligned() {
        int n;
        this.pos = n = MathUtils.roundUpInt(this.pos + 2, 16);
        if (this.data.length < n) {
            this.checkCapacity(n - this.data.length);
        }
    }

    public static void copyString(Reader reader, OutputStream outputStream) throws IOException {
        int n;
        char[] cArray = new char[4096];
        Data data2 = new Data(null, new byte[12288]);
        while ((n = reader.read(cArray)) >= 0) {
            data2.writeStringWithoutLength(cArray, n);
            outputStream.write(data2.data, 0, data2.pos);
            data2.reset();
        }
    }

    public DataHandler getHandler() {
        return this.handler;
    }
}

