/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.New;
import org.h2.value.Value;

public class RowList {
    private final Session session;
    private final ArrayList<Row> list = New.arrayList();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private Data rowBuff;
    private ArrayList<Value> lobs;
    private final int maxMemory;
    private int memory;
    private boolean written;
    private boolean readUncached;

    public RowList(Session session) {
        this.session = session;
        this.maxMemory = session.getDatabase().isPersistent() ? session.getDatabase().getMaxOperationMemory() : 0;
    }

    private void writeRow(Data data2, Row row) {
        data2.checkCapacity(33);
        data2.writeByte((byte)1);
        data2.writeInt(row.getMemory());
        int n = row.getColumnCount();
        data2.writeInt(n);
        data2.writeLong(row.getKey());
        data2.writeInt(row.getVersion());
        data2.writeInt(row.isDeleted() ? 1 : 0);
        data2.writeInt(row.getSessionId());
        for (int i = 0; i < n; ++i) {
            Value value = row.getValue(i);
            data2.checkCapacity(1);
            if (value == null) {
                data2.writeByte((byte)0);
                continue;
            }
            data2.writeByte((byte)1);
            if ((value.getType() == 16 || value.getType() == 15) && value.getSmall() == null && value.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = New.arrayList();
                }
                value = value.copyToTemp();
                this.lobs.add(value);
            }
            data2.checkCapacity(data2.getValueLen(value));
            data2.writeValue(value);
        }
    }

    private void writeAllRows() {
        Object object;
        if (this.file == null) {
            object = this.session.getDatabase();
            String string = ((Database)object).createTempFile();
            this.file = ((Database)object).openFile(string, "rw", false);
            this.file.setCheckedWriting(false);
            this.file.seek(48L);
            this.rowBuff = Data.create((DataHandler)object, 4096);
            this.file.seek(48L);
        }
        object = this.rowBuff;
        RowList.initBuffer((Data)object);
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0 && ((Data)object).length() > 4096) {
                this.flushBuffer((Data)object);
                RowList.initBuffer((Data)object);
            }
            Row row = this.list.get(i);
            this.writeRow((Data)object, row);
        }
        this.flushBuffer((Data)object);
        this.file.autoDelete();
        this.list.clear();
        this.memory = 0;
    }

    private static void initBuffer(Data data2) {
        data2.reset();
        data2.writeInt(0);
    }

    private void flushBuffer(Data data2) {
        data2.checkCapacity(1);
        data2.writeByte((byte)0);
        data2.fillAligned();
        data2.setInt(0, data2.length() / 16);
        this.file.write(data2.getBytes(), 0, data2.length());
    }

    public void add(Row row) {
        this.list.add(row);
        this.memory += row.getMemory() + 8;
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(Data data2) {
        if (data2.readByte() == 0) {
            return null;
        }
        int n = data2.readInt();
        int n2 = data2.readInt();
        long l = data2.readLong();
        int n3 = data2.readInt();
        if (this.readUncached) {
            l = 0L;
        }
        boolean bl = data2.readInt() == 1;
        int n4 = data2.readInt();
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            Value value;
            if (data2.readByte() == 0) {
                value = null;
            } else {
                value = data2.readValue();
                if (value.isLinkedToTable() && value.getTableId() == 0) {
                    this.session.removeAtCommit(value);
                }
            }
            valueArray[i] = value;
        }
        Row row = this.session.createRow(valueArray, n);
        row.setKey(l);
        row.setVersion(n3);
        row.setDeleted(bl);
        row.setSessionId(n4);
        return row;
    }

    public Row next() {
        Row row;
        if (this.file == null) {
            row = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                Data data2 = this.rowBuff;
                data2.reset();
                int n = 16;
                this.file.readFully(data2.getBytes(), 0, n);
                int n2 = data2.readInt() * 16;
                data2.checkCapacity(n2);
                if (n2 - n > 0) {
                    this.file.readFully(data2.getBytes(), n, n2 - n);
                }
                while ((row = this.readRow(data2)) != null) {
                    this.list.add(row);
                }
            }
            ++this.index;
            row = this.list.get(this.listIndex++);
        }
        return row;
    }

    public int size() {
        return this.size;
    }

    public void invalidateCache() {
        this.readUncached = true;
    }

    public void close() {
        if (this.file != null) {
            this.file.autoDelete();
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

