/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.h2.mvstore.DataUtils;

public class CacheLongKeyLIRS<V> {
    private long maxMemory;
    private final Segment<V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;
    private final int nonResidentQueueSize;

    public CacheLongKeyLIRS(Config config) {
        this.setMaxMemory(config.maxMemory);
        this.nonResidentQueueSize = config.nonResidentQueueSize;
        DataUtils.checkArgument(Integer.bitCount(config.segmentCount) == 1, "The segment count must be a power of 2, is {0}", config.segmentCount);
        this.segmentCount = config.segmentCount;
        this.segmentMask = this.segmentCount - 1;
        this.stackMoveDistance = config.stackMoveDistance;
        this.segments = new Segment[this.segmentCount];
        this.clear();
        this.segmentShift = 32 - Integer.bitCount(this.segmentMask);
    }

    public void clear() {
        long l = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segments[i] = new Segment(l, this.stackMoveDistance, 8, this.nonResidentQueueSize);
        }
    }

    private Entry<V> find(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).find(l, n);
    }

    public boolean containsKey(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).containsKey(l, n);
    }

    public V peek(long l) {
        Entry<V> entry = this.find(l);
        return entry == null ? null : (V)entry.value;
    }

    public V put(long l, V v) {
        return this.put(l, v, this.sizeOf(v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long l, V v, int n) {
        Segment<V> segment;
        int n2 = CacheLongKeyLIRS.getHash(l);
        int n3 = this.getSegmentIndex(n2);
        Segment<V> segment2 = segment = this.segments[n3];
        synchronized (segment2) {
            segment = this.resizeIfNeeded(segment, n3);
            return segment.put(l, n2, v, n);
        }
    }

    private Segment<V> resizeIfNeeded(Segment<V> segment, int n) {
        int n2 = segment.getNewMapLen();
        if (n2 == 0) {
            return segment;
        }
        Segment<V> segment2 = this.segments[n];
        if (segment == segment2) {
            segment = new Segment<V>(segment, n2);
            this.segments[n] = segment;
        }
        return segment;
    }

    protected int sizeOf(V v) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long l) {
        Segment<V> segment;
        int n = CacheLongKeyLIRS.getHash(l);
        int n2 = this.getSegmentIndex(n);
        Segment<V> segment2 = segment = this.segments[n2];
        synchronized (segment2) {
            segment = this.resizeIfNeeded(segment, n2);
            return segment.remove(l, n);
        }
    }

    public int getMemory(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).getMemory(l, n);
    }

    public V get(long l) {
        int n = CacheLongKeyLIRS.getHash(l);
        return this.getSegment(n).get(l, n);
    }

    private Segment<V> getSegment(int n) {
        return this.segments[this.getSegmentIndex(n)];
    }

    private int getSegmentIndex(int n) {
        return n >>> this.segmentShift & this.segmentMask;
    }

    static int getHash(long l) {
        int n = (int)(l >>> 32 ^ l);
        n = (n >>> 16 ^ n) * 73244475;
        n = (n >>> 16 ^ n) * 73244475;
        n = n >>> 16 ^ n;
        return n;
    }

    public long getUsedMemory() {
        long l = 0L;
        for (Segment<V> segment : this.segments) {
            l += segment.usedMemory;
        }
        return l;
    }

    public void setMaxMemory(long l) {
        DataUtils.checkArgument(l > 0L, "Max memory must be larger than 0, is {0}", l);
        this.maxMemory = l;
        if (this.segments != null) {
            long l2 = 1L + l / (long)this.segments.length;
            for (Segment<V> segment : this.segments) {
                segment.setMaxMemory(l2);
            }
        }
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<Long, V>> entrySet() {
        HashMap hashMap = new HashMap();
        for (long l : this.keySet()) {
            hashMap.put(l, this.find((long)l).value);
        }
        return hashMap.entrySet();
    }

    public Set<Long> keySet() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Segment<V> segment : this.segments) {
            hashSet.addAll(segment.keySet());
        }
        return hashSet;
    }

    public int sizeNonResident() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.queue2Size;
        }
        return n;
    }

    public int sizeMapArray() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.entries.length;
        }
        return n;
    }

    public int sizeHot() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.mapSize - segment.queueSize - segment.queue2Size;
        }
        return n;
    }

    public long getHits() {
        long l = 0L;
        for (Segment<V> segment : this.segments) {
            l += segment.hits;
        }
        return l;
    }

    public long getMisses() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n = (int)((long)n + segment.misses);
        }
        return n;
    }

    public int size() {
        int n = 0;
        for (Segment<V> segment : this.segments) {
            n += segment.mapSize - segment.queue2Size;
        }
        return n;
    }

    public List<Long> keys(boolean bl, boolean bl2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Segment<V> segment : this.segments) {
            arrayList.addAll(segment.keys(bl, bl2));
        }
        return arrayList;
    }

    public List<V> values() {
        ArrayList arrayList = new ArrayList();
        for (long l : this.keySet()) {
            Object v = this.find((long)l).value;
            if (v == null) continue;
            arrayList.add(v);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object object) {
        return this.getMap().containsValue(object);
    }

    public Map<Long, V> getMap() {
        HashMap hashMap = new HashMap();
        for (long l : this.keySet()) {
            Object v = this.find((long)l).value;
            if (v == null) continue;
            hashMap.put(l, v);
        }
        return hashMap;
    }

    public void putAll(Map<Long, ? extends V> map2) {
        for (Map.Entry<Long, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public static class Config {
        public long maxMemory = 1L;
        public int segmentCount = 16;
        public int stackMoveDistance = 32;
        public int nonResidentQueueSize = 3;
    }

    static class Entry<V> {
        long key;
        V value;
        int memory;
        int topMove;
        Entry<V> stackNext;
        Entry<V> stackPrev;
        Entry<V> queueNext;
        Entry<V> queuePrev;
        Entry<V> mapNext;

        Entry() {
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    private static class Segment<V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        long hits;
        long misses;
        final Entry<V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private final int mask;
        private final int nonResidentQueueSize;
        private final Entry<V> stack;
        private int stackSize;
        private final Entry<V> queue;
        private final Entry<V> queue2;
        private int stackMoveCounter;

        Segment(long l, int n, int n2, int n3) {
            this.setMaxMemory(l);
            this.stackMoveDistance = n;
            this.nonResidentQueueSize = n3;
            this.mask = n2 - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] entryArray = new Entry[n2];
            this.entries = entryArray;
        }

        Segment(Segment<V> segment, int n) {
            this(segment.maxMemory, segment.stackMoveDistance, n, segment.nonResidentQueueSize);
            Entry entry;
            this.hits = segment.hits;
            this.misses = segment.misses;
            Entry entry2 = segment.stack.stackPrev;
            while (entry2 != segment.stack) {
                entry = Segment.copy(entry2);
                super.addToMap(entry);
                super.addToStack(entry);
                entry2 = entry2.stackPrev;
            }
            entry2 = segment.queue.queuePrev;
            while (entry2 != segment.queue) {
                entry = this.find(entry2.key, CacheLongKeyLIRS.getHash(entry2.key));
                if (entry == null) {
                    entry = Segment.copy(entry2);
                    super.addToMap(entry);
                }
                super.addToQueue(this.queue, entry);
                entry2 = entry2.queuePrev;
            }
            entry2 = segment.queue2.queuePrev;
            while (entry2 != segment.queue2) {
                entry = this.find(entry2.key, CacheLongKeyLIRS.getHash(entry2.key));
                if (entry == null) {
                    entry = Segment.copy(entry2);
                    super.addToMap(entry);
                }
                super.addToQueue(this.queue2, entry);
                entry2 = entry2.queuePrev;
            }
        }

        int getNewMapLen() {
            int n = this.mask + 1;
            if (n * 3 < this.mapSize * 4 && n < 0x10000000) {
                return n * 2;
            }
            if (n > 32 && n / 8 > this.mapSize) {
                return n / 2;
            }
            return 0;
        }

        private void addToMap(Entry<V> entry) {
            int n = CacheLongKeyLIRS.getHash(entry.key) & this.mask;
            entry.mapNext = this.entries[n];
            this.entries[n] = entry;
            this.usedMemory += (long)entry.memory;
            ++this.mapSize;
        }

        private static <V> Entry<V> copy(Entry<V> entry) {
            Entry entry2 = new Entry();
            entry2.key = entry.key;
            entry2.value = entry.value;
            entry2.memory = entry.memory;
            entry2.topMove = entry.topMove;
            return entry2;
        }

        int getMemory(long l, int n) {
            Entry<V> entry = this.find(l, n);
            return entry == null ? 0 : entry.memory;
        }

        V get(long l, int n) {
            Entry<V> entry = this.find(l, n);
            if (entry == null) {
                ++this.misses;
                return null;
            }
            Object v = entry.value;
            if (v == null) {
                ++this.misses;
                return null;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    this.access(l, n);
                }
            } else {
                this.access(l, n);
            }
            ++this.hits;
            return v;
        }

        private synchronized void access(long l, int n) {
            Entry<V> entry = this.find(l, n);
            if (entry == null || entry.value == null) {
                return;
            }
            if (entry.isHot()) {
                if (entry != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - entry.topMove > this.stackMoveDistance)) {
                    boolean bl = entry == this.stack.stackPrev;
                    this.removeFromStack(entry);
                    if (bl) {
                        this.pruneStack();
                    }
                    this.addToStack(entry);
                }
            } else {
                this.removeFromQueue(entry);
                if (entry.stackNext != null) {
                    this.removeFromStack(entry);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, entry);
                }
                this.addToStack(entry);
            }
        }

        synchronized V put(long l, int n, V v, int n2) {
            V v2;
            boolean bl;
            if (v == null) {
                throw DataUtils.newIllegalArgumentException("The value may not be null", new Object[0]);
            }
            Entry<V> entry = this.find(l, n);
            if (entry == null) {
                bl = false;
                v2 = null;
            } else {
                bl = true;
                v2 = entry.value;
                this.remove(l, n);
            }
            if ((long)n2 > this.maxMemory) {
                return v2;
            }
            entry = new Entry();
            entry.key = l;
            entry.value = v;
            entry.memory = n2;
            int n3 = n & this.mask;
            entry.mapNext = this.entries[n3];
            this.entries[n3] = entry;
            this.usedMemory += (long)n2;
            if (this.usedMemory > this.maxMemory) {
                this.evict();
                if (this.stackSize > 0) {
                    this.addToQueue(this.queue, entry);
                }
            }
            ++this.mapSize;
            this.addToStack(entry);
            if (bl) {
                this.access(l, n);
            }
            return v2;
        }

        synchronized V remove(long l, int n) {
            Object v;
            int n2 = n & this.mask;
            Entry<V> entry = this.entries[n2];
            if (entry == null) {
                return null;
            }
            if (entry.key == l) {
                v = entry.value;
                this.entries[n2] = entry.mapNext;
            } else {
                do {
                    Entry<V> entry2 = entry;
                    entry = entry.mapNext;
                    if (entry != null) continue;
                    return null;
                } while (entry.key != l);
                v = entry.value;
                entry2.mapNext = entry.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)entry.memory;
            if (entry.stackNext != null) {
                this.removeFromStack(entry);
            }
            if (entry.isHot()) {
                entry = this.queue.queueNext;
                if (entry != this.queue) {
                    this.removeFromQueue(entry);
                    if (entry.stackNext == null) {
                        this.addToStackBottom(entry);
                    }
                }
            } else {
                this.removeFromQueue(entry);
            }
            this.pruneStack();
            return v;
        }

        private void evict() {
            do {
                this.evictBlock();
            } while (this.usedMemory > this.maxMemory);
        }

        private void evictBlock() {
            while (this.queueSize <= this.mapSize >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 0) {
                Entry entry = this.queue.queuePrev;
                this.usedMemory -= (long)entry.memory;
                this.removeFromQueue(entry);
                entry.value = null;
                entry.memory = 0;
                this.addToQueue(this.queue2, entry);
                int n = this.nonResidentQueueSize * (this.mapSize - this.queue2Size);
                if (n < 0) continue;
                while (this.queue2Size > n) {
                    entry = this.queue2.queuePrev;
                    int n2 = CacheLongKeyLIRS.getHash(entry.key);
                    this.remove(entry.key, n2);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry entry = this.stack.stackPrev;
            if (entry == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(entry);
            this.addToQueue(this.queue, entry);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry entry;
            while (!(entry = this.stack.stackPrev).isHot()) {
                this.removeFromStack(entry);
            }
        }

        Entry<V> find(long l, int n) {
            int n2 = n & this.mask;
            Entry<V> entry = this.entries[n2];
            while (entry != null && entry.key != l) {
                entry = entry.mapNext;
            }
            return entry;
        }

        private void addToStack(Entry<V> entry) {
            entry.stackPrev = this.stack;
            entry.stackNext = this.stack.stackNext;
            entry.stackNext.stackPrev = entry;
            this.stack.stackNext = entry;
            ++this.stackSize;
            entry.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<V> entry) {
            entry.stackNext = this.stack;
            entry.stackPrev = this.stack.stackPrev;
            entry.stackPrev.stackNext = entry;
            this.stack.stackPrev = entry;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<V> entry) {
            entry.stackPrev.stackNext = entry.stackNext;
            entry.stackNext.stackPrev = entry.stackPrev;
            entry.stackNext = null;
            entry.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<V> entry, Entry<V> entry2) {
            entry2.queuePrev = entry;
            entry2.queueNext = entry.queueNext;
            entry2.queueNext.queuePrev = entry2;
            entry.queueNext = entry2;
            if (entry2.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<V> entry) {
            entry.queuePrev.queueNext = entry.queueNext;
            entry.queueNext.queuePrev = entry.queuePrev;
            entry.queueNext = null;
            entry.queuePrev = null;
            if (entry.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<Long> keys(boolean bl, boolean bl2) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (bl) {
                Entry<V> entry = bl2 ? this.queue2 : this.queue;
                Entry entry2 = entry.queueNext;
                while (entry2 != entry) {
                    arrayList.add(entry2.key);
                    entry2 = entry2.queueNext;
                }
            } else {
                Entry entry = this.stack.stackNext;
                while (entry != this.stack) {
                    arrayList.add(entry.key);
                    entry = entry.stackNext;
                }
            }
            return arrayList;
        }

        boolean containsKey(long l, int n) {
            Entry<V> entry = this.find(l, n);
            return entry != null && entry.value != null;
        }

        synchronized Set<Long> keySet() {
            HashSet<Long> hashSet = new HashSet<Long>();
            Entry entry = this.stack.stackNext;
            while (entry != this.stack) {
                hashSet.add(entry.key);
                entry = entry.stackNext;
            }
            entry = this.queue.queueNext;
            while (entry != this.queue) {
                hashSet.add(entry.key);
                entry = entry.queueNext;
            }
            return hashSet;
        }

        void setMaxMemory(long l) {
            this.maxMemory = l;
        }
    }
}

