/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.h2.mvstore.ConcurrentArrayList;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.Page;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.New;

public class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    protected MVStore store;
    protected volatile Page root;
    protected volatile long writeVersion;
    private int id;
    private long createVersion;
    private final DataType keyType;
    private final DataType valueType;
    private ConcurrentArrayList<Page> oldRoots = new ConcurrentArrayList();
    private volatile boolean closed;
    private boolean readOnly;
    private boolean isVolatile;

    protected MVMap(DataType dataType, DataType dataType2) {
        this.keyType = dataType;
        this.valueType = dataType2;
        this.root = Page.createEmpty(this, -1L);
    }

    static String getMapRootKey(int n) {
        return "root." + Integer.toHexString(n);
    }

    static String getMapKey(int n) {
        return "map." + Integer.toHexString(n);
    }

    protected void init(MVStore mVStore, HashMap<String, Object> hashMap) {
        this.store = mVStore;
        this.id = DataUtils.readHexInt(hashMap, "id", 0);
        this.createVersion = DataUtils.readHexLong(hashMap, "createVersion", 0L);
        this.writeVersion = mVStore.getCurrentVersion();
    }

    @Override
    public synchronized V put(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        this.beforeWrite();
        long l = this.writeVersion;
        Page page = this.root.copy(l);
        page = this.splitRootIfNeeded(page, l);
        Object object = this.put(page, l, k, v);
        this.newRoot(page);
        return (V)object;
    }

    synchronized Page putBranch(Page page, K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        long l = this.writeVersion;
        Page page2 = page.copy(l);
        page2 = this.splitRootIfNeeded(page2, l);
        this.put(page2, l, k, v);
        return page2;
    }

    protected Page splitRootIfNeeded(Page page, long l) {
        if (page.getMemory() <= this.store.getPageSplitSize() || page.getKeyCount() <= 1) {
            return page;
        }
        int n = page.getKeyCount() / 2;
        long l2 = page.getTotalCount();
        Object object = page.getKey(n);
        Page page2 = page.split(n);
        Object[] objectArray = new Object[]{object};
        Page.PageReference[] pageReferenceArray = new Page.PageReference[]{new Page.PageReference(page, page.getPos(), page.getTotalCount()), new Page.PageReference(page2, page2.getPos(), page2.getTotalCount())};
        page = Page.create(this, l, objectArray, null, pageReferenceArray, l2, 0);
        return page;
    }

    protected Object put(Page page, long l, Object object, Object object2) {
        int n = page.binarySearch(object);
        if (page.isLeaf()) {
            if (n < 0) {
                n = -n - 1;
                page.insertLeaf(n, object, object2);
                return null;
            }
            return page.setValue(n, object2);
        }
        n = n < 0 ? -n - 1 : ++n;
        Page page2 = page.getChildPage(n).copy(l);
        if (page2.getMemory() > this.store.getPageSplitSize() && page2.getKeyCount() > 1) {
            int n2 = page2.getKeyCount() / 2;
            Object object3 = page2.getKey(n2);
            Page page3 = page2.split(n2);
            page.setChild(n, page3);
            page.insertNode(n, object3, page2);
            return this.put(page, l, object, object2);
        }
        Object object4 = this.put(page2, l, object, object2);
        page.setChild(n, page2);
        return object4;
    }

    public K firstKey() {
        return this.getFirstLast(true);
    }

    public K lastKey() {
        return this.getFirstLast(false);
    }

    public K getKey(long l) {
        if (l < 0L || l >= (long)this.size()) {
            return null;
        }
        Page page = this.root;
        long l2 = 0L;
        while (true) {
            long l3;
            int n;
            if (page.isLeaf()) {
                if (l >= l2 + (long)page.getKeyCount()) {
                    return null;
                }
                return (K)page.getKey((int)(l - l2));
            }
            int n2 = this.getChildPageCount(page);
            for (n = 0; n < n2 && l >= (l3 = page.getCounts(n)) + l2; ++n) {
                l2 += l3;
            }
            if (n == n2) {
                return null;
            }
            page = page.getChildPage(n);
        }
    }

    public List<K> keyList() {
        return new AbstractList<K>(){

            @Override
            public K get(int n) {
                return MVMap.this.getKey(n);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public int indexOf(Object object) {
                return (int)MVMap.this.getKeyIndex(object);
            }
        };
    }

    public long getKeyIndex(K k) {
        if (this.size() == 0) {
            return -1L;
        }
        Page page = this.root;
        long l = 0L;
        while (true) {
            int n = page.binarySearch(k);
            if (page.isLeaf()) {
                if (n < 0) {
                    return -l + (long)n;
                }
                return l + (long)n;
            }
            n = n < 0 ? -n - 1 : ++n;
            for (int i = 0; i < n; ++i) {
                l += page.getCounts(i);
            }
            page = page.getChildPage(n);
        }
    }

    protected K getFirstLast(boolean bl) {
        if (this.size() == 0) {
            return null;
        }
        Page page = this.root;
        while (!page.isLeaf()) {
            page = page.getChildPage(bl ? 0 : this.getChildPageCount(page) - 1);
        }
        return (K)page.getKey(bl ? 0 : page.getKeyCount() - 1);
    }

    public K higherKey(K k) {
        return this.getMinMax(k, false, true);
    }

    public K ceilingKey(K k) {
        return this.getMinMax(k, false, false);
    }

    public K floorKey(K k) {
        return this.getMinMax(k, true, false);
    }

    public K lowerKey(K k) {
        return this.getMinMax(k, true, true);
    }

    protected K getMinMax(K k, boolean bl, boolean bl2) {
        return this.getMinMax(this.root, k, bl, bl2);
    }

    private K getMinMax(Page page, K k, boolean bl, boolean bl2) {
        if (page.isLeaf()) {
            int n = page.binarySearch(k);
            if (n < 0) {
                n = -n - (bl ? 2 : 1);
            } else if (bl2) {
                n += bl ? -1 : 1;
            }
            if (n < 0 || n >= page.getKeyCount()) {
                return null;
            }
            return (K)page.getKey(n);
        }
        int n = page.binarySearch(k);
        n = n < 0 ? -n - 1 : ++n;
        while (n >= 0 && n < this.getChildPageCount(page)) {
            K k2 = this.getMinMax(page.getChildPage(n), k, bl, bl2);
            if (k2 != null) {
                return k2;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    @Override
    public V get(Object object) {
        return (V)this.binarySearch(this.root, object);
    }

    protected Object binarySearch(Page page, Object object) {
        int n = page.binarySearch(object);
        if (!page.isLeaf()) {
            n = n < 0 ? -n - 1 : ++n;
            page = page.getChildPage(n);
            return this.binarySearch(page, object);
        }
        if (n >= 0) {
            return page.getValue(n);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    protected Page binarySearchPage(Page page, Object object) {
        int n = page.binarySearch(object);
        if (!page.isLeaf()) {
            n = n < 0 ? -n - 1 : ++n;
            page = page.getChildPage(n);
            return this.binarySearchPage(page, object);
        }
        if (n >= 0) {
            return page;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.beforeWrite();
        this.root.removeAllRecursive();
        this.newRoot(Page.createEmpty(this, this.writeVersion));
    }

    void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        this.beforeWrite();
        Object object2 = this.get(object);
        if (object2 == null) {
            return null;
        }
        long l = this.writeVersion;
        MVMap mVMap = this;
        synchronized (mVMap) {
            Page page = this.root.copy(l);
            object2 = this.remove(page, l, object);
            if (!page.isLeaf() && page.getTotalCount() == 0L) {
                page.removePage();
                page = Page.createEmpty(this, page.getVersion());
            }
            this.newRoot(page);
        }
        return object2;
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        V v2 = this.get(k);
        if (v2 == null) {
            this.put(k, v);
        }
        return v2;
    }

    @Override
    public synchronized boolean remove(Object object, Object object2) {
        V v = this.get(object);
        if (this.areValuesEqual(v, object2)) {
            this.remove(object);
            return true;
        }
        return false;
    }

    public boolean areValuesEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return this.valueType.compare(object, object2) == 0;
    }

    @Override
    public synchronized boolean replace(K k, V v, V v2) {
        V v3 = this.get(k);
        if (this.areValuesEqual(v3, v)) {
            this.put(k, v2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        V v2 = this.get(k);
        if (v2 != null) {
            this.put(k, v);
            return v2;
        }
        return null;
    }

    protected Object remove(Page page, long l, Object object) {
        int n = page.binarySearch(object);
        Object object2 = null;
        if (page.isLeaf()) {
            if (n >= 0) {
                object2 = page.getValue(n);
                page.remove(n);
            }
            return object2;
        }
        n = n < 0 ? -n - 1 : ++n;
        Page page2 = page.getChildPage(n);
        Page page3 = page2.copy(l);
        object2 = this.remove(page3, l, object);
        if (object2 == null || page3.getTotalCount() != 0L) {
            page.setChild(n, page3);
        } else if (page.getKeyCount() == 0) {
            page.setChild(n, page3);
            page3.removePage();
        } else {
            page.remove(n);
        }
        return object2;
    }

    protected void newRoot(Page page) {
        if (this.root != page) {
            Page page2;
            this.removeUnusedOldVersions();
            if (this.root.getVersion() != page.getVersion() && ((page2 = this.oldRoots.peekLast()) == null || page2.getVersion() != this.root.getVersion())) {
                this.oldRoots.add(this.root);
            }
            this.root = page;
        }
    }

    int compare(Object object, Object object2) {
        return this.keyType.compare(object, object2);
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    Page readPage(long l) {
        return this.store.readPage(this, l);
    }

    void setRootPos(long l, long l2) {
        this.root = l == 0L ? Page.createEmpty(this, -1L) : this.readPage(l);
        this.root.setVersion(l2);
    }

    public Iterator<K> keyIterator(K k) {
        return new Cursor(this, this.root, k);
    }

    boolean rewrite(Set<Integer> set) {
        MVMap<K, V> mVMap;
        long l = this.store.getCurrentVersion() - 1L;
        if (l < this.createVersion) {
            return true;
        }
        try {
            mVMap = this.openVersion(l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        try {
            this.rewrite(mVMap.root, set);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            if (DataUtils.getErrorCode(illegalStateException.getMessage()) == 9) {
                return false;
            }
            throw illegalStateException;
        }
    }

    private int rewrite(Page page, Set<Integer> set) {
        long l;
        int n;
        if (page.isLeaf()) {
            Object object;
            V v;
            long l2 = page.getPos();
            int n2 = DataUtils.getPageChunkId(l2);
            if (!set.contains(n2)) {
                return 0;
            }
            if (page.getKeyCount() > 0 && (v = this.get(object = page.getKey(0))) != null) {
                this.replace(object, v, v);
            }
            return 1;
        }
        int n3 = 0;
        for (int i = 0; i < this.getChildPageCount(page); ++i) {
            int n4;
            long l3 = page.getChildPagePos(i);
            if (l3 != 0L && DataUtils.getPageType(l3) == 0 && !set.contains(n4 = DataUtils.getPageChunkId(l3))) continue;
            n3 += this.rewrite(page.getChildPage(i), set);
        }
        if (n3 == 0 && set.contains(n = DataUtils.getPageChunkId(l = page.getPos()))) {
            Page page2 = page;
            while (!page2.isLeaf()) {
                page2 = page2.getChildPage(0);
            }
            Object object = page2.getKey(0);
            V v = this.get(object);
            if (v != null) {
                this.replace(object, v, v);
            }
            ++n3;
        }
        return n3;
    }

    public Cursor<K, V> cursor(K k) {
        return new Cursor(this, this.root, k);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final MVMap mVMap = this;
        final Page page = this.root;
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Cursor cursor = new Cursor(mVMap, page, null);
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = cursor.next();
                        return new DataUtils.MapEntry(k, cursor.getValue());
                    }

                    @Override
                    public void remove() {
                        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                    }
                };
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final MVMap mVMap = this;
        final Page page = this.root;
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Cursor(mVMap, page, null);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    public Page getRoot() {
        return this.root;
    }

    public String getName() {
        return this.store.getMapName(this.id);
    }

    public MVStore getStore() {
        return this.store;
    }

    public int getId() {
        return this.id;
    }

    void rollbackTo(long l) {
        this.beforeWrite();
        if (l > this.createVersion && this.root.getVersion() >= l) {
            Page page;
            while ((page = this.oldRoots.peekLast()) != null) {
                this.oldRoots.removeLast(page);
                this.root = page;
                if (this.root.getVersion() >= l) continue;
                break;
            }
        }
    }

    void removeUnusedOldVersions() {
        Page page;
        long l = this.store.getOldestVersionToKeep();
        if (l == -1L) {
            return;
        }
        Page page2 = this.oldRoots.peekLast();
        while ((page = this.oldRoots.peekFirst()) != null && page.getVersion() < l && page != page2) {
            this.oldRoots.removeFirst(page);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    protected void beforeWrite() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This map is closed", new Object[0]);
        }
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only");
        }
        this.store.beforeWrite(this);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int size() {
        long l = this.sizeAsLong();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public long sizeAsLong() {
        return this.root.getTotalCount();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isLeaf() && this.root.getKeyCount() == 0;
    }

    public long getCreateVersion() {
        return this.createVersion;
    }

    protected void removePage(long l, int n) {
        this.store.removePage(this, l, n);
    }

    public MVMap<K, V> openVersion(long l) {
        Object object;
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only; need to call the method on the writable map");
        }
        DataUtils.checkArgument(l >= this.createVersion, "Unknown version {0}; this map was created in version is {1}", l, this.createVersion);
        Object object2 = null;
        Page page = this.root;
        if (l >= page.getVersion() && (l == this.writeVersion || page.getVersion() >= 0L || l <= this.createVersion || this.store.getFileStore() == null)) {
            object2 = page;
        } else {
            Page page2;
            object = this.oldRoots.peekFirst();
            if (object == null || l < ((Page)object).getVersion()) {
                return this.store.openMapVersion(l, this.id, this);
            }
            Iterator<Page> iterator2 = this.oldRoots.iterator();
            while (iterator2.hasNext() && (page2 = iterator2.next()).getVersion() <= l) {
                object = page2;
            }
            object2 = object;
        }
        object = this.openReadOnly();
        ((MVMap)object).root = object2;
        return object;
    }

    MVMap<K, V> openReadOnly() {
        MVMap<K, V> mVMap = new MVMap<K, V>(this.keyType, this.valueType);
        mVMap.readOnly = true;
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("id", this.id);
        hashMap.put("createVersion", this.createVersion);
        mVMap.init(this.store, hashMap);
        mVMap.root = this.root;
        return mVMap;
    }

    public long getVersion() {
        return this.root.getVersion();
    }

    protected int getChildPageCount(Page page) {
        return page.getRawChildPageCount();
    }

    public String getType() {
        return null;
    }

    String asString(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            DataUtils.appendMap(stringBuilder, "name", string);
        }
        if (this.createVersion != 0L) {
            DataUtils.appendMap(stringBuilder, "createVersion", this.createVersion);
        }
        if ((string2 = this.getType()) != null) {
            DataUtils.appendMap(stringBuilder, "type", string2);
        }
        return stringBuilder.toString();
    }

    void setWriteVersion(long l) {
        this.writeVersion = l;
    }

    void copyFrom(MVMap<K, V> mVMap) {
        this.beforeWrite();
        this.newRoot(this.copy(mVMap.root, null));
    }

    private Page copy(Page page, CursorPos cursorPos) {
        Page page2 = Page.create(this, this.writeVersion, page);
        if (page.isLeaf()) {
            Page page3 = page2;
            CursorPos cursorPos2 = cursorPos;
            while (cursorPos2 != null) {
                cursorPos2.page.setChild(cursorPos2.index, page3);
                page3 = cursorPos2.page = cursorPos2.page.copy(this.writeVersion);
                if (cursorPos2.parent == null) {
                    this.newRoot(cursorPos2.page);
                    this.beforeWrite();
                }
                cursorPos2 = cursorPos2.parent;
            }
        } else {
            for (int i = 0; i < this.getChildPageCount(page2); ++i) {
                page2.setChild(i, null);
            }
            CursorPos cursorPos3 = new CursorPos(page2, 0, cursorPos);
            for (int i = 0; i < this.getChildPageCount(page2); ++i) {
                cursorPos3.index = i;
                long l = page.getChildPagePos(i);
                if (l == 0L) continue;
                this.copy(page.getChildPage(i), cursorPos3);
            }
            page2 = cursorPos3.page;
        }
        return page2;
    }

    @Override
    public String toString() {
        return this.asString(null);
    }

    public static class Builder<K, V>
    implements MapBuilder<MVMap<K, V>, K, V> {
        protected DataType keyType;
        protected DataType valueType;

        public Builder<K, V> keyType(DataType dataType) {
            this.keyType = dataType;
            return this;
        }

        public DataType getKeyType() {
            return this.keyType;
        }

        public DataType getValueType() {
            return this.valueType;
        }

        public Builder<K, V> valueType(DataType dataType) {
            this.valueType = dataType;
            return this;
        }

        @Override
        public MVMap<K, V> create() {
            if (this.keyType == null) {
                this.keyType = new ObjectDataType();
            }
            if (this.valueType == null) {
                this.valueType = new ObjectDataType();
            }
            return new MVMap(this.keyType, this.valueType);
        }
    }

    public static interface MapBuilder<M extends MVMap<K, V>, K, V> {
        public M create();
    }
}

