/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.net.Proxy;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class RequestLine {
    private RequestLine() {
    }

    public static String get(Request request, Proxy.Type proxyType) {
        StringBuilder result2 = new StringBuilder();
        result2.append(request.method());
        result2.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result2.append(request.url());
        } else {
            result2.append(RequestLine.requestPath(request.url()));
        }
        result2.append(" HTTP/1.1");
        return result2.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(HttpUrl url2) {
        String path = url2.encodedPath();
        String query2 = url2.encodedQuery();
        return query2 != null ? path + '?' + query2 : path;
    }
}

