/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental.scheduling;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import kotlinx.coroutines.experimental.DefaultExecutor;
import kotlinx.coroutines.experimental.Delay;
import kotlinx.coroutines.experimental.DisposableHandle;
import kotlinx.coroutines.experimental.scheduling.CoroutineScheduler;
import kotlinx.coroutines.experimental.scheduling.LimitingBlockingDispatcher;
import kotlinx.coroutines.experimental.scheduling.TaskContext;
import kotlinx.coroutines.experimental.scheduling.TaskMode;
import kotlinx.coroutines.experimental.scheduling.TasksKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J)\u0010\u0017\u001a\u00020\u00102\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u001c\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J&\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0016J\u0015\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020'H\u0016J\r\u0010(\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkotlinx/coroutines/experimental/scheduling/ExperimentalCoroutineDispatcher;", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "Lkotlinx/coroutines/experimental/Delay;", "Ljava/io/Closeable;", "corePoolSize", "", "maxPoolSize", "(II)V", "idleWorkerKeepAliveNs", "", "(IIJ)V", "coroutineScheduler", "Lkotlinx/coroutines/experimental/scheduling/CoroutineScheduler;", "blocking", "parallelism", "close", "", "dispatch", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/experimental/Runnable;", "dispatchWithContext", "Lkotlinx/coroutines/experimental/scheduling/TaskContext;", "fair", "", "dispatchWithContext$kotlinx_coroutines_core", "dispatchYield", "scheduleResumeAfterDelay", "time", "unit", "Ljava/util/concurrent/TimeUnit;", "continuation", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "shutdown", "timeout", "shutdown$kotlinx_coroutines_core", "toString", "", "usePrivateScheduler", "usePrivateScheduler$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
public final class ExperimentalCoroutineDispatcher
extends CoroutineDispatcher
implements Delay,
Closeable {
    private CoroutineScheduler coroutineScheduler;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long idleWorkerKeepAliveNs;

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        CoroutineScheduler.dispatch$default(this.coroutineScheduler, block, null, false, 6, null);
    }

    @Override
    public void dispatchYield(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        CoroutineScheduler.dispatch$default(this.coroutineScheduler, block, null, true, 2, null);
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        DefaultExecutor.INSTANCE.scheduleResumeAfterDelay(time, unit, continuation2);
    }

    @Override
    public void close() {
        this.coroutineScheduler.close();
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "[scheduler = " + this.coroutineScheduler + ']';
    }

    @NotNull
    public final CoroutineDispatcher blocking(int parallelism) {
        boolean bl;
        boolean bl2 = bl = parallelism > 0;
        if (!bl) {
            String string = "Expected positive parallelism level, but have " + parallelism;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new LimitingBlockingDispatcher(this, parallelism, TaskMode.PROBABLY_BLOCKING);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CoroutineDispatcher blocking$default(ExperimentalCoroutineDispatcher experimentalCoroutineDispatcher, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = TasksKt.BLOCKING_DEFAULT_PARALLELISM;
        }
        return experimentalCoroutineDispatcher.blocking(n);
    }

    public final void dispatchWithContext$kotlinx_coroutines_core(@NotNull Runnable block, @NotNull TaskContext context, boolean fair) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.coroutineScheduler.dispatch(block, context, fair);
    }

    public final void usePrivateScheduler$kotlinx_coroutines_core() {
        this.coroutineScheduler.shutdown(1000L);
        this.coroutineScheduler = new CoroutineScheduler(this.corePoolSize, this.maxPoolSize, this.idleWorkerKeepAliveNs, null, 8, null);
    }

    public final void shutdown$kotlinx_coroutines_core(long timeout) {
        this.coroutineScheduler.shutdown(timeout);
    }

    public ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.coroutineScheduler = new CoroutineScheduler(this.corePoolSize, this.maxPoolSize, this.idleWorkerKeepAliveNs, null, 8, null);
    }

    public ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize) {
        this(corePoolSize, maxPoolSize, TasksKt.IDLE_WORKER_KEEP_ALIVE_NS);
    }

    public /* synthetic */ ExperimentalCoroutineDispatcher(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = TasksKt.CORE_POOL_SIZE;
        }
        if ((n3 & 2) != 0) {
            n2 = TasksKt.MAX_POOL_SIZE;
        }
        this(n, n2);
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> continuation2) {
        return Delay.DefaultImpls.delay(this, time, unit, continuation2);
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(block, "block");
        return Delay.DefaultImpls.invokeOnTimeout(this, time, unit, block);
    }
}

