/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.experimental.CommonPool;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import kotlinx.coroutines.experimental.DefaultExecutor;
import kotlinx.coroutines.experimental.TimeSourceKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0082\b\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u0010\u001a\u00060\u001aj\u0002`\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0002J!\u0010\u001d\u001a\u00020\r2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0004H\u0016J\r\u0010\f\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkotlinx/coroutines/experimental/CommonPool;", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "()V", "DEFAULT_PARALLELISM_PROPERTY_NAME", "", "parallelism", "", "getParallelism", "()I", "pool", "Ljava/util/concurrent/Executor;", "requestedParallelism", "usePrivatePool", "", "Try", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createPlainPool", "Ljava/util/concurrent/ExecutorService;", "createPool", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/experimental/Runnable;", "getOrCreatePoolSync", "isGoodCommonPool", "fjpClass", "Ljava/lang/Class;", "executor", "isGoodCommonPool$kotlinx_coroutines_core", "restore", "restore$kotlinx_coroutines_core", "shutdown", "timeout", "", "shutdown$kotlinx_coroutines_core", "toString", "usePrivatePool$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
public final class CommonPool
extends CoroutineDispatcher {
    @NotNull
    public static final String DEFAULT_PARALLELISM_PROPERTY_NAME = "kotlinx.coroutines.default.parallelism";
    private static final int requestedParallelism;
    private static boolean usePrivatePool;
    private static volatile Executor pool;
    public static final CommonPool INSTANCE;

    private final int getParallelism() {
        Integer n = requestedParallelism;
        int it = ((Number)n).intValue();
        Integer n2 = it > 0 ? n : null;
        return n2 != null ? n2 : RangesKt.coerceAtLeast(Runtime.getRuntime().availableProcessors() - 1, 1);
    }

    private final <T> T Try(Function0<? extends T> block) {
        T t;
        try {
            t = block.invoke();
        }
        catch (Throwable e) {
            t = null;
        }
        return t;
    }

    private final ExecutorService createPool() {
        Object $i$a$3$let;
        Object it;
        Class<?> $i$a$1$Try;
        if (System.getSecurityManager() != null) {
            return this.createPlainPool();
        }
        Object this_$iv = this;
        try {
            $i$a$1$Try = Class.forName("java.util.concurrent.ForkJoinPool");
        }
        catch (Throwable e$iv) {
            $i$a$1$Try = null;
        }
        Class<?> clazz = $i$a$1$Try;
        if (clazz == null) {
            return this.createPlainPool();
        }
        Class<?> fjpClass = clazz;
        if (!usePrivatePool && requestedParallelism < 0) {
            Object object;
            ExecutorService e$iv;
            this_$iv = this;
            try {
                Method method = fjpClass.getMethod("commonPool", new Class[0]);
                Object object2 = method != null ? method.invoke(null, new Object[0]) : null;
                if (!(object2 instanceof ExecutorService)) {
                    object2 = null;
                }
                e$iv = (ExecutorService)object2;
            }
            catch (Throwable e$iv2) {
                e$iv = null;
            }
            if ((object = e$iv) != null && (object = INSTANCE.isGoodCommonPool$kotlinx_coroutines_core(fjpClass, (ExecutorService)(it = (this_$iv = object))) ? this_$iv : null) != null) {
                it = this_$iv = object;
                return it;
            }
        }
        this_$iv = this;
        try {
            Object obj = fjpClass.getConstructor(Integer.TYPE).newInstance(INSTANCE.getParallelism());
            if (!(obj instanceof ExecutorService)) {
                obj = null;
            }
            $i$a$3$let = (ExecutorService)obj;
        }
        catch (Throwable e$iv) {
            $i$a$3$let = null;
        }
        CommonPool commonPool = $i$a$3$let;
        if (commonPool != null) {
            CommonPool commonPool2 = commonPool;
            it = commonPool2;
            return it;
        }
        return this.createPlainPool();
    }

    public final boolean isGoodCommonPool$kotlinx_coroutines_core(@NotNull Class<?> fjpClass, @NotNull ExecutorService executor2) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(fjpClass, "fjpClass");
        Intrinsics.checkParameterIsNotNull(executor2, "executor");
        executor2.submit(isGoodCommonPool.1.INSTANCE);
        CommonPool this_$iv = this;
        try {
            Object object = fjpClass.getMethod("getPoolSize", new Class[0]).invoke((Object)executor2, new Object[0]);
            if (!(object instanceof Integer)) {
                object = null;
            }
            n = (Integer)object;
        }
        catch (Throwable e$iv) {
            n = null;
        }
        Integer n2 = n;
        if (n2 == null) {
            return false;
        }
        int actual = n2;
        return actual >= 1;
    }

    private final ExecutorService createPlainPool() {
        AtomicInteger threadId = new AtomicInteger();
        ExecutorService executorService = Executors.newFixedThreadPool(this.getParallelism(), new ThreadFactory(threadId){
            final /* synthetic */ AtomicInteger $threadId;

            @NotNull
            public final Thread newThread(Runnable it) {
                Thread thread2;
                Thread $receiver = thread2 = new Thread(it, "CommonPool-worker-" + this.$threadId.incrementAndGet());
                $receiver.setDaemon(true);
                return thread2;
            }
            {
                this.$threadId = atomicInteger;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(executorService, "Executors.newFixedThread\u2026Daemon = true }\n        }");
        return executorService;
    }

    private final synchronized Executor getOrCreatePoolSync() {
        Executor executor2 = pool;
        if (executor2 == null) {
            ExecutorService executorService;
            ExecutorService it = executorService = this.createPool();
            pool = it;
            executor2 = executorService;
        }
        return executor2;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        try {
            Executor executor2 = pool;
            if (executor2 == null) {
                executor2 = this.getOrCreatePoolSync();
            }
            executor2.execute(TimeSourceKt.getTimeSource().trackTask(block));
        }
        catch (RejectedExecutionException e) {
            TimeSourceKt.getTimeSource().unTrackTask();
            DefaultExecutor.INSTANCE.execute$kotlinx_coroutines_core(block);
        }
    }

    public final synchronized void usePrivatePool$kotlinx_coroutines_core() {
        this.shutdown$kotlinx_coroutines_core(0L);
        usePrivatePool = true;
        pool = null;
    }

    public final synchronized void shutdown$kotlinx_coroutines_core(long timeout) {
        Executor executor2 = pool;
        if (!(executor2 instanceof ExecutorService)) {
            executor2 = null;
        }
        ExecutorService executorService = (ExecutorService)executor2;
        if (executorService != null) {
            ExecutorService executorService2;
            ExecutorService $receiver = executorService2 = executorService;
            $receiver.shutdown();
            if (timeout > 0L) {
                $receiver.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            List<Runnable> list = $receiver.shutdownNow();
            Intrinsics.checkExpressionValueIsNotNull(list, "shutdownNow()");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Runnable it;
                Runnable runnable = it = (Runnable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(runnable, "it");
                DefaultExecutor.INSTANCE.execute$kotlinx_coroutines_core(runnable);
            }
        }
        pool = shutdown.2.INSTANCE;
    }

    public final synchronized void restore$kotlinx_coroutines_core() {
        this.shutdown$kotlinx_coroutines_core(0L);
        usePrivatePool = false;
        pool = null;
    }

    @Override
    @NotNull
    public String toString() {
        return "CommonPool";
    }

    private CommonPool() {
    }

    static {
        int n;
        String string;
        CommonPool commonPool;
        INSTANCE = commonPool = new CommonPool();
        CommonPool this_$iv = INSTANCE;
        try {
            string = System.getProperty(DEFAULT_PARALLELISM_PROPERTY_NAME);
        }
        catch (Throwable e$iv) {
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            n = -1;
        } else {
            String property = string2;
            Integer parallelism = StringsKt.toIntOrNull(property);
            if (parallelism == null || parallelism < 1) {
                string = "Expected positive number in kotlinx.coroutines.default.parallelism, but has " + property;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            n = parallelism;
        }
        requestedParallelism = n;
    }
}

