/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringValue
extends ConstantValue<String> {
    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        return module.getBuiltIns().getStringType();
    }

    @Override
    @NotNull
    public String toString() {
        return '\"' + (String)this.getValue() + '\"';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        String string = (String)this.getValue();
        Object object = other;
        if (!(object instanceof StringValue)) {
            object = null;
        }
        StringValue stringValue = (StringValue)object;
        if (!Intrinsics.areEqual(string, stringValue != null ? (String)stringValue.getValue() : null)) return false;
        return true;
    }

    public int hashCode() {
        return ((String)this.getValue()).hashCode();
    }

    public StringValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        super(value);
    }
}

