/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model.request;

import com.pengrad.telegrambot.AttachName;
import com.pengrad.telegrambot.model.request.ParseMode;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class InputMedia<T extends InputMedia>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final T thisAsT = this;
    private final String type;
    private final String media;
    private String thumb;
    private String caption;
    private String parse_mode;
    private transient Map<String, Object> attachments = new HashMap<String, Object>();
    private transient String filename;

    InputMedia(String type2, Object media) {
        this.type = type2;
        if (media instanceof String) {
            this.media = (String)media;
        } else {
            String attachName = AttachName.next();
            this.media = "attach://" + attachName;
            this.attachments.put(attachName, media);
            if (media instanceof File) {
                this.filename = ((File)media).getName();
            }
        }
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }

    public T thumb(File thumb) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumb);
        this.thumb = "attach://" + attachName;
        return this.thisAsT;
    }

    public T thumb(byte[] thumb) {
        String attachName = AttachName.next();
        this.attachments.put(attachName, thumb);
        this.thumb = "attach://" + attachName;
        return this.thisAsT;
    }

    public T caption(String caption) {
        this.caption = caption;
        return this.thisAsT;
    }

    public T parseMode(ParseMode parseMode) {
        this.parse_mode = parseMode.name();
        return this.thisAsT;
    }

    public String getFileName() {
        return this.filename != null ? this.filename : this.getDefaultFileName();
    }

    protected abstract String getDefaultFileName();

    public abstract String getContentType();
}

