/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot;

import com.google.gson.Gson;
import com.pengrad.telegrambot.BotUtils;
import com.pengrad.telegrambot.Callback;
import com.pengrad.telegrambot.UpdatesListener;
import com.pengrad.telegrambot.impl.FileApi;
import com.pengrad.telegrambot.impl.TelegramBotClient;
import com.pengrad.telegrambot.impl.UpdatesHandler;
import com.pengrad.telegrambot.model.File;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.GetUpdates;
import com.pengrad.telegrambot.response.BaseResponse;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class TelegramBot {
    private final TelegramBotClient api;
    private final FileApi fileApi;
    private final UpdatesHandler updatesHandler;

    public TelegramBot(String botToken) {
        this(new Builder(botToken));
    }

    TelegramBot(Builder builder) {
        this.api = builder.api;
        this.fileApi = builder.fileApi;
        this.updatesHandler = builder.updatesHandler;
    }

    public <T extends BaseRequest, R extends BaseResponse> R execute(BaseRequest<T, R> request) {
        return this.api.send(request);
    }

    public <T extends BaseRequest<T, R>, R extends BaseResponse> void execute(T request, Callback<T, R> callback) {
        this.api.send(request, callback);
    }

    public String getFullFilePath(File file) {
        return this.fileApi.getFullFilePath(file.filePath());
    }

    public byte[] getFileContent(File file) throws Exception {
        String fileUrl = this.getFullFilePath(file);
        URLConnection connection = new URL(fileUrl).openConnection();
        InputStream is = connection.getInputStream();
        byte[] data2 = BotUtils.getBytesFromInputStream(is);
        is.close();
        return data2;
    }

    public void setUpdatesListener(UpdatesListener listener) {
        this.setUpdatesListener(listener, new GetUpdates());
    }

    public void setUpdatesListener(UpdatesListener listener, GetUpdates request) {
        this.updatesHandler.start(this, listener, request);
    }

    public void removeGetUpdatesListener() {
        this.updatesHandler.stop();
    }

    public static final class Builder {
        static final String API_URL = "https://api.telegram.org/bot";
        private final String botToken;
        private final FileApi fileApi;
        private TelegramBotClient api;
        private UpdatesHandler updatesHandler;
        private OkHttpClient okHttpClient;
        private String apiUrl;

        public Builder(String botToken) {
            this.botToken = botToken;
            this.api = new TelegramBotClient(Builder.client(null), Builder.gson(), Builder.apiUrl(API_URL, botToken));
            this.fileApi = new FileApi(botToken);
            this.updatesHandler = new UpdatesHandler(100L);
        }

        public Builder debug() {
            this.okHttpClient = Builder.client(Builder.httpLoggingInterceptor());
            return this;
        }

        public Builder okHttpClient(OkHttpClient client) {
            this.okHttpClient = client;
            return this;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder updateListenerSleep(long millis) {
            this.updatesHandler = new UpdatesHandler(millis);
            return this;
        }

        public TelegramBot build() {
            if (this.okHttpClient != null || this.apiUrl != null) {
                OkHttpClient client = this.okHttpClient != null ? this.okHttpClient : Builder.client(null);
                String baseUrl = Builder.apiUrl(this.apiUrl != null ? this.apiUrl : API_URL, this.botToken);
                this.api = new TelegramBotClient(client, Builder.gson(), baseUrl);
            }
            return new TelegramBot(this);
        }

        private static OkHttpClient client(Interceptor interceptor) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (interceptor != null) {
                builder.addInterceptor(interceptor);
            }
            return builder.build();
        }

        private static Interceptor httpLoggingInterceptor() {
            return new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
        }

        private static Gson gson() {
            return new Gson();
        }

        private static String apiUrl(String apiUrl, String botToken) {
            return apiUrl + botToken + "/";
        }
    }
}

