/*
 * Decompiled with CFR 0.152.
 */
package json.value;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

final class MyPrettifyOutputStream
extends OutputStream {
    private static final int INDENT_CACHE_SIZE = 257;
    private static final boolean[] WHITESPACE = new boolean[256];
    private final OutputStream out;
    private final IndentType indentType;
    private final int indentLength;
    private int currentIndent = 0;
    private boolean inString = false;
    private boolean inEscape = false;
    private boolean beginObjectOrList = false;

    public MyPrettifyOutputStream(OutputStream outputStream) {
        this(outputStream, IndentType.SPACES, 2);
    }

    private MyPrettifyOutputStream(OutputStream outputStream, IndentType indentType, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("'indentLength' must be >= 1");
        }
        this.out = outputStream;
        this.indentType = indentType;
        this.indentLength = n;
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        for (n3 = n; n3 < n + n2; ++n3) {
            byte by = byArray[n3];
            if (this.inString) {
                if (by == 34 && !this.inEscape) {
                    this.inString = false;
                    continue;
                }
                this.inEscape = !this.inEscape && by == 92;
                continue;
            }
            if (by == 34) {
                this.inString = true;
                if (!this.beginObjectOrList) continue;
                this.writeNewLineWithIndent();
                this.beginObjectOrList = false;
                continue;
            }
            if (by == 44) {
                this.out.write(byArray, n4, n3 - n4 + 1);
                n4 = n3 + 1;
                this.writeNewLineWithIndent();
                continue;
            }
            if (by == 58) {
                this.out.write(byArray, n4, n3 - n4 + 1);
                n4 = n3 + 1;
                this.out.write(32);
                continue;
            }
            if (by == 123 || by == 91) {
                if (this.beginObjectOrList) {
                    this.writeNewLineWithIndent();
                }
                this.beginObjectOrList = true;
                this.currentIndent += this.indentLength;
                this.out.write(byArray, n4, n3 - n4 + 1);
                n4 = n3 + 1;
                continue;
            }
            if (by == 125 || by == 93) {
                this.currentIndent -= this.indentLength;
                this.out.write(byArray, n4, n3 - n4);
                if (this.beginObjectOrList) {
                    this.beginObjectOrList = false;
                } else {
                    this.writeNewLineWithIndent();
                }
                this.out.write(by);
                n4 = n3 + 1;
                continue;
            }
            if (WHITESPACE[by]) {
                this.out.write(byArray, n4, n3 - n4);
                n4 = n3 + 1;
                continue;
            }
            if (!this.beginObjectOrList) continue;
            this.writeNewLineWithIndent();
            this.beginObjectOrList = false;
        }
        n3 = n + n2 - n4;
        if (n3 > 0) {
            this.out.write(byArray, n4, n3);
        }
    }

    @Override
    public final void write(int n) throws IOException {
        if (this.inString) {
            if (n == 34 && !this.inEscape) {
                this.inString = false;
            } else {
                this.inEscape = !this.inEscape && n == 92;
            }
            this.out.write(n);
        } else if (n == 34) {
            this.inString = true;
            if (this.beginObjectOrList) {
                this.writeNewLineWithIndent();
                this.beginObjectOrList = false;
            }
            this.out.write(n);
        } else if (n == 44) {
            this.out.write(44);
            this.writeNewLineWithIndent();
        } else if (n == 58) {
            this.out.write(58);
            this.out.write(32);
        } else if (n == 123 || n == 91) {
            if (this.beginObjectOrList) {
                this.writeNewLineWithIndent();
            }
            this.beginObjectOrList = true;
            this.currentIndent += this.indentLength;
            this.out.write(n);
        } else if (n == 125 || n == 93) {
            this.currentIndent -= this.indentLength;
            if (this.beginObjectOrList) {
                this.beginObjectOrList = false;
            } else {
                this.writeNewLineWithIndent();
            }
            this.out.write(n);
        } else if (!WHITESPACE[n]) {
            if (this.beginObjectOrList) {
                this.writeNewLineWithIndent();
                this.beginObjectOrList = false;
            }
            this.out.write(n);
        }
    }

    private void writeNewLineWithIndent() throws IOException {
        int n = this.currentIndent + 1;
        if (n < 257) {
            this.out.write(this.indentType.cache, 0, n);
        } else {
            byte[] byArray = this.indentType.cache;
            this.out.write(byArray);
            int n2 = n - 257;
            while (true) {
                if (n2 < 257) {
                    this.out.write(byArray, 1, n2);
                    break;
                }
                this.out.write(byArray, 1, 256);
                n2 -= 256;
            }
        }
    }

    static {
        MyPrettifyOutputStream.WHITESPACE[9] = true;
        MyPrettifyOutputStream.WHITESPACE[10] = true;
        MyPrettifyOutputStream.WHITESPACE[13] = true;
        MyPrettifyOutputStream.WHITESPACE[32] = true;
    }

    public static enum IndentType {
        SPACES(32),
        TABS(9);

        private final byte[] cache = new byte[257];

        private IndentType(byte by) {
            this.cache[0] = 10;
            Arrays.fill(this.cache, 1, this.cache.length, by);
        }
    }
}

