/*
 * Decompiled with CFR 0.152.
 */
package json.value;

import com.dslplatform.json.JsonReader;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import json.value.FALSE$;
import json.value.InternalError$;
import json.value.InvalidJson;
import json.value.InvalidJson$;
import json.value.JsArrayParser$;
import json.value.JsBigDec;
import json.value.JsNull$;
import json.value.JsNumber$;
import json.value.JsObj;
import json.value.JsObjParser;
import json.value.JsStr;
import json.value.JsValue;
import json.value.Parser$;
import json.value.TRUE$;
import json.value.ValueParserFactory$;
import json.value.spec.$times$;
import json.value.spec.ArrayOfObjSpec;
import json.value.spec.IsArraySpec;
import json.value.spec.IsObjSpec;
import json.value.spec.JsArraySpec;
import json.value.spec.JsObjSpec;
import json.value.spec.JsPredicate;
import json.value.spec.JsSpec;
import json.value.spec.NamedKey;
import json.value.spec.Schema;
import json.value.spec.SpecKey;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;

public final class JsObjParser$
implements Serializable {
    public static final JsObjParser$ MODULE$ = new JsObjParser$();

    public boolean $lessinit$greater$default$2() {
        return false;
    }

    public Try<JsObj> parse(InputStream inputStream) {
        Object object;
        try (JsonParser parser = null;){
            parser = value.package$.MODULE$.jacksonFactory().createParser(Objects.requireNonNull(inputStream));
            JsonToken event = parser.nextToken();
            object = event == JsonToken.START_ARRAY ? new Failure((Throwable)InvalidJson$.MODULE$.jsObjectExpected()) : new Success((Object)this.parse(parser));
        }
        return object;
    }

    public Either<InvalidJson, JsObj> parse(byte[] bytes) {
        Left left;
        block7: {
            try (JsonParser parser = null;){
                try {
                    parser = value.package$.MODULE$.jacksonFactory().createParser(Objects.requireNonNull(bytes));
                    JsonToken event = parser.nextToken();
                    if (event == JsonToken.START_ARRAY) {
                        left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.jsObjectExpected());
                        break block7;
                    }
                    left = package$.MODULE$.Right().apply((Object)this.parse(parser));
                }
                catch (IOException e) {
                    left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.errorWhileParsing(bytes, e));
                }
            }
        }
        return left;
    }

    public Either<InvalidJson, JsObj> parse(String str) {
        Left left;
        block7: {
            try (JsonParser parser = null;){
                try {
                    parser = value.package$.MODULE$.jacksonFactory().createParser(Objects.requireNonNull(str));
                    JsonToken event = parser.nextToken();
                    if (event == JsonToken.START_ARRAY) {
                        left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.jsObjectExpected());
                        break block7;
                    }
                    left = package$.MODULE$.Right().apply((Object)this.parse(parser));
                }
                catch (IOException e) {
                    left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.errorWhileParsing(str, e));
                }
            }
        }
        return left;
    }

    public JsObj parse(JsonParser parser) throws IOException {
        HashMap map = HashMap$.MODULE$.empty();
        String key = parser.nextFieldName();
        while (key != null) {
            JsValue value = null;
            int n = parser.nextToken().id();
            switch (n) {
                case 6: {
                    value = new JsStr(parser.getValueAsString());
                    break;
                }
                case 7: {
                    value = JsNumber$.MODULE$.apply(parser);
                    break;
                }
                case 8: {
                    value = new JsBigDec(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(parser.getDecimalValue()));
                    break;
                }
                case 10: {
                    value = FALSE$.MODULE$;
                    break;
                }
                case 9: {
                    value = TRUE$.MODULE$;
                    break;
                }
                case 11: {
                    value = JsNull$.MODULE$;
                    break;
                }
                case 1: {
                    value = this.parse(parser);
                    break;
                }
                case 3: {
                    value = JsArrayParser$.MODULE$.parse(parser);
                    break;
                }
                default: {
                    throw InternalError$.MODULE$.tokenNotFoundParsingStringIntoJsObj(parser.currentToken().name());
                }
            }
            map = (Map)map.updated((Object)key, (Object)value);
            key = parser.nextFieldName();
        }
        return new JsObj((Map<String, JsValue>)map);
    }

    public Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> createDeserializers(Map<SpecKey, JsSpec> spec, Map<String, Function<JsonReader<?>, JsValue>> result, Vector<String> requiredKeys) {
        while (!spec.isEmpty()) {
            SpecKey specKey = (SpecKey)JsObjParser$.head$2(spec)._1();
            if ($times$.MODULE$.equals(specKey)) {
                result = result.withDefaultValue(ValueParserFactory$.MODULE$.ofValue());
                spec = (Map)spec.tail();
                continue;
            }
            if (specKey instanceof NamedKey) {
                NamedKey namedKey = (NamedKey)specKey;
                String name = namedKey.name();
                JsSpec jsSpec = (JsSpec)JsObjParser$.head$2(spec)._2();
                if (jsSpec instanceof Schema) {
                    Schema schema = (Schema)jsSpec;
                    Schema schema2 = schema;
                    if (schema2 instanceof JsObjSpec) {
                        JsObjSpec jsObjSpec = (JsObjSpec)schema2;
                        Map<SpecKey, JsSpec> map = jsObjSpec.map();
                        Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = this.createDeserializers(map, (Map<String, Function<JsonReader<?>, JsValue>>)HashMap$.MODULE$.empty(), (Vector<String>)package$.MODULE$.Vector().empty());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Vector headRequired = (Vector)tuple2._1();
                        Map headDeserializers = (Map)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)headRequired, (Object)headDeserializers);
                        Tuple2 tuple23 = tuple22;
                        Vector headRequired2 = (Vector)tuple23._1();
                        Map headDeserializers2 = (Map)tuple23._2();
                        requiredKeys = requiredKeys.appended((Object)name);
                        result = (Map)result.updated((Object)name, ValueParserFactory$.MODULE$.ofObjSpec((Vector<String>)headRequired2, headDeserializers2, ValueParserFactory$.MODULE$.ofObjSpec$default$3()));
                        spec = (Map)spec.tail();
                        continue;
                    }
                    if (schema2 instanceof IsObjSpec) {
                        IsObjSpec isObjSpec = (IsObjSpec)schema2;
                        JsObjSpec headSpec = isObjSpec.spec();
                        boolean nullable = isObjSpec.nullable();
                        boolean required = isObjSpec.required();
                        Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = this.createDeserializers(headSpec.map(), (Map<String, Function<JsonReader<?>, JsValue>>)HashMap$.MODULE$.empty(), (Vector<String>)package$.MODULE$.Vector().empty());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Vector headRequired = (Vector)tuple2._1();
                        Map headDeserializers = (Map)tuple2._2();
                        Tuple2 tuple24 = new Tuple2((Object)headRequired, (Object)headDeserializers);
                        Tuple2 tuple25 = tuple24;
                        Vector headRequired3 = (Vector)tuple25._1();
                        Map headDeserializers3 = (Map)tuple25._2();
                        requiredKeys = required ? requiredKeys.appended((Object)name) : requiredKeys;
                        result = (Map)result.updated((Object)name, ValueParserFactory$.MODULE$.ofObjSpec((Vector<String>)headRequired3, headDeserializers3, nullable));
                        spec = (Map)spec.tail();
                        continue;
                    }
                    if (schema2 instanceof IsArraySpec) {
                        IsArraySpec isArraySpec = (IsArraySpec)schema2;
                        JsArraySpec headSpec = isArraySpec.spec();
                        boolean nullable = isArraySpec.nullable();
                        boolean required = isArraySpec.required();
                        Vector<Function<JsonReader<?>, JsValue>> headDeserializers = JsArrayParser$.MODULE$.createDeserializers(headSpec.seq(), package$.MODULE$.Vector().empty());
                        requiredKeys = required ? requiredKeys.appended((Object)name) : requiredKeys;
                        result = (Map)result.updated((Object)name, ValueParserFactory$.MODULE$.ofArraySpec(headDeserializers, nullable));
                        spec = (Map)spec.tail();
                        continue;
                    }
                    if (schema2 instanceof JsArraySpec) {
                        JsArraySpec jsArraySpec = (JsArraySpec)schema2;
                        Seq<JsSpec> seq = jsArraySpec.seq();
                        result = (Map)result.updated((Object)name, ValueParserFactory$.MODULE$.ofArraySpec(JsArrayParser$.MODULE$.createDeserializers(seq, package$.MODULE$.Vector().empty()), false));
                        spec = (Map)spec.tail();
                        continue;
                    }
                    if (schema2 instanceof ArrayOfObjSpec) {
                        ArrayOfObjSpec arrayOfObjSpec = (ArrayOfObjSpec)schema2;
                        JsObjSpec objSpec = arrayOfObjSpec.spec();
                        boolean nullable = arrayOfObjSpec.nullable();
                        boolean required = arrayOfObjSpec.required();
                        boolean elemNullable = arrayOfObjSpec.elemNullable();
                        Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = this.createDeserializers(objSpec.map(), (Map<String, Function<JsonReader<?>, JsValue>>)HashMap$.MODULE$.empty(), (Vector<String>)package$.MODULE$.Vector().empty());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Vector headRequired = (Vector)tuple2._1();
                        Map headDeserializers = (Map)tuple2._2();
                        Tuple2 tuple26 = new Tuple2((Object)headRequired, (Object)headDeserializers);
                        Tuple2 tuple27 = tuple26;
                        Vector headRequired4 = (Vector)tuple27._1();
                        Map headDeserializers4 = (Map)tuple27._2();
                        requiredKeys = required ? requiredKeys.appended((Object)name) : requiredKeys;
                        result = (Map)result.updated((Object)name, ValueParserFactory$.MODULE$.ofArrayOfObjSpec((Vector<String>)headRequired4, headDeserializers4, nullable, elemNullable));
                        spec = (Map)spec.tail();
                        continue;
                    }
                    throw new MatchError((Object)schema2);
                }
                if (jsSpec instanceof JsPredicate) {
                    JsPredicate jsPredicate = (JsPredicate)jsSpec;
                    Tuple2<Object, Function<JsonReader<?>, JsValue>> tuple2 = Parser$.MODULE$.getDeserializer(jsPredicate);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    boolean required = tuple2._1$mcZ$sp();
                    Function fn = (Function)tuple2._2();
                    Tuple2 tuple28 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)required), (Object)fn);
                    Tuple2 tuple29 = tuple28;
                    boolean required2 = tuple29._1$mcZ$sp();
                    Function fn2 = (Function)tuple29._2();
                    requiredKeys = required2 ? requiredKeys.appended((Object)name) : requiredKeys;
                    result = (Map)result.updated((Object)name, (Object)fn2);
                    spec = (Map)spec.tail();
                    continue;
                }
                throw new MatchError((Object)jsSpec);
            }
            throw new MatchError((Object)specKey);
        }
        return new Tuple2(requiredKeys, result);
    }

    public JsObjParser apply(JsObjSpec spec, boolean additionalKeys) {
        return new JsObjParser(spec, additionalKeys);
    }

    public boolean apply$default$2() {
        return false;
    }

    public Option<Tuple2<JsObjSpec, Object>> unapply(JsObjParser x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.spec(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.additionalKeys())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsObjParser$.class);
    }

    private static final Tuple2 head$2(Map spec$2) {
        return (Tuple2)spec$2.head();
    }

    private JsObjParser$() {
    }
}

