/*
 * Decompiled with CFR 0.152.
 */
package json.value;

import com.dslplatform.json.JsonReader;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import json.value.FALSE$;
import json.value.InternalError$;
import json.value.InvalidJson;
import json.value.InvalidJson$;
import json.value.JsArray;
import json.value.JsArrayParser;
import json.value.JsBigDec;
import json.value.JsNull$;
import json.value.JsNumber$;
import json.value.JsObjParser$;
import json.value.JsStr;
import json.value.JsValue;
import json.value.Parser$;
import json.value.TRUE$;
import json.value.ValueParserFactory$;
import json.value.spec.ArrayOfObjSpec;
import json.value.spec.IsArraySpec;
import json.value.spec.IsObjSpec;
import json.value.spec.JsArraySpec;
import json.value.spec.JsObjSpec;
import json.value.spec.JsPredicate;
import json.value.spec.JsSpec;
import json.value.spec.Schema;
import json.value.spec.SpecKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;

public final class JsArrayParser$
implements Serializable {
    public static final JsArrayParser$ MODULE$ = new JsArrayParser$();

    public JsArrayParser apply(JsPredicate predicate) {
        Function deserializer = (Function)Parser$.MODULE$.getDeserializer(predicate)._2();
        return new JsArrayParser(deserializer);
    }

    public JsArrayParser apply(JsArraySpec spec) {
        Vector<Function<JsonReader<?>, JsValue>> deserializers = this.createDeserializers(spec.seq(), package$.MODULE$.Vector().empty());
        Function<JsonReader<?>, JsValue> arrayDeserializer = ValueParserFactory$.MODULE$.ofArraySpec(deserializers, false);
        return new JsArrayParser(arrayDeserializer);
    }

    public JsArrayParser apply(ArrayOfObjSpec arrayOfObjSpec) {
        Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = JsObjParser$.MODULE$.createDeserializers(arrayOfObjSpec.spec().map(), HashMap$.MODULE$.empty().withDefault((Function1 & Serializable)key -> (Function)Parser$.MODULE$.fn().apply(key)), (Vector<String>)package$.MODULE$.Vector().empty());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector required = (Vector)tuple2._1();
        Map deserializers = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)required, (Object)deserializers);
        Tuple2 tuple23 = tuple22;
        Vector required2 = (Vector)tuple23._1();
        Map deserializers2 = (Map)tuple23._2();
        Function<JsonReader<?>, JsValue> arrayDeserializer = ValueParserFactory$.MODULE$.ofArrayOfObjSpec((Vector<String>)required2, deserializers2, arrayOfObjSpec.nullable(), arrayOfObjSpec.elemNullable());
        return new JsArrayParser(arrayDeserializer);
    }

    public Try<JsArray> parse(InputStream inputStream) {
        Object object;
        try (JsonParser parser = null;){
            parser = value.package$.MODULE$.jacksonFactory().createParser(Objects.requireNonNull(inputStream));
            JsonToken event = parser.nextToken();
            object = event == JsonToken.START_OBJECT ? new Failure((Throwable)InvalidJson$.MODULE$.jsArrayExpected()) : new Success((Object)this.parse(parser));
        }
        return object;
    }

    public Either<InvalidJson, JsArray> parse(byte[] bytes) {
        Left left;
        block7: {
            try (JsonParser parser = null;){
                try {
                    parser = value.package$.MODULE$.jacksonFactory().createParser(Objects.requireNonNull(bytes));
                    JsonToken event = parser.nextToken();
                    if (event == JsonToken.START_OBJECT) {
                        left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.jsArrayExpected());
                        break block7;
                    }
                    left = package$.MODULE$.Right().apply((Object)this.parse(parser));
                }
                catch (IOException e) {
                    left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.errorWhileParsing(bytes, e));
                }
            }
        }
        return left;
    }

    public Either<InvalidJson, JsArray> parse(String str) {
        Left left;
        block7: {
            try (JsonParser parser = null;){
                try {
                    parser = value.package$.MODULE$.jacksonFactory().createParser(Objects.requireNonNull(str));
                    JsonToken event = parser.nextToken();
                    if (event == JsonToken.START_OBJECT) {
                        left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.jsArrayExpected());
                        break block7;
                    }
                    left = package$.MODULE$.Right().apply((Object)this.parse(parser));
                }
                catch (IOException e) {
                    left = package$.MODULE$.Left().apply((Object)InvalidJson$.MODULE$.errorWhileParsing(str, e));
                }
            }
        }
        return left;
    }

    public JsArray parse(JsonParser parser) throws IOException {
        Vector root = package$.MODULE$.Vector().empty();
        while (true) {
            JsonToken token = parser.nextToken();
            JsValue value = null;
            int n = token.id();
            switch (n) {
                case 4: {
                    return new JsArray((Seq<JsValue>)root);
                }
                case 1: {
                    value = JsObjParser$.MODULE$.parse(parser);
                    break;
                }
                case 3: {
                    value = this.parse(parser);
                    break;
                }
                case 6: {
                    value = new JsStr(parser.getValueAsString());
                    break;
                }
                case 7: {
                    value = JsNumber$.MODULE$.apply(parser);
                    break;
                }
                case 8: {
                    value = new JsBigDec(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(parser.getDecimalValue()));
                    break;
                }
                case 9: {
                    value = TRUE$.MODULE$;
                    break;
                }
                case 10: {
                    value = FALSE$.MODULE$;
                    break;
                }
                case 11: {
                    value = JsNull$.MODULE$;
                    break;
                }
                default: {
                    throw InternalError$.MODULE$.tokenNotFoundParsingStringIntoJsArray(token.name());
                }
            }
            root = root.appended((Object)value);
        }
    }

    public Vector<Function<JsonReader<?>, JsValue>> createDeserializers(Seq<JsSpec> spec, Vector<Function<JsonReader<?>, JsValue>> result) {
        JsSpec jsSpec;
        while (true) {
            if (spec.isEmpty()) {
                return result;
            }
            jsSpec = JsArrayParser$.head$1(spec);
            if (jsSpec instanceof Schema) {
                Schema schema = (Schema)jsSpec;
                Schema schema2 = schema;
                if (schema2 instanceof JsObjSpec) {
                    JsObjSpec jsObjSpec = (JsObjSpec)schema2;
                    Map<SpecKey, JsSpec> map = jsObjSpec.map();
                    Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = JsObjParser$.MODULE$.createDeserializers(map, (Map<String, Function<JsonReader<?>, JsValue>>)HashMap$.MODULE$.empty(), (Vector<String>)package$.MODULE$.Vector().empty());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Vector required = (Vector)tuple2._1();
                    Map deserializers = (Map)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)required, (Object)deserializers);
                    Tuple2 tuple23 = tuple22;
                    Vector required2 = (Vector)tuple23._1();
                    Map deserializers2 = (Map)tuple23._2();
                    result = result.appended(ValueParserFactory$.MODULE$.ofObjSpec((Vector<String>)required2, deserializers2, ValueParserFactory$.MODULE$.ofObjSpec$default$3()));
                    spec = (Seq)spec.tail();
                    continue;
                }
                if (schema2 instanceof IsObjSpec) {
                    IsObjSpec isObjSpec = (IsObjSpec)schema2;
                    JsObjSpec headSpec = isObjSpec.spec();
                    boolean headNullable = isObjSpec.nullable();
                    Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = JsObjParser$.MODULE$.createDeserializers(headSpec.map(), (Map<String, Function<JsonReader<?>, JsValue>>)HashMap$.MODULE$.empty(), (Vector<String>)package$.MODULE$.Vector().empty());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Vector required = (Vector)tuple2._1();
                    Map deserializers = (Map)tuple2._2();
                    Tuple2 tuple24 = new Tuple2((Object)required, (Object)deserializers);
                    Tuple2 tuple25 = tuple24;
                    Vector required3 = (Vector)tuple25._1();
                    Map deserializers3 = (Map)tuple25._2();
                    result = result.appended(ValueParserFactory$.MODULE$.ofObjSpec((Vector<String>)required3, deserializers3, headNullable));
                    spec = (Seq)spec.tail();
                    continue;
                }
                if (schema2 instanceof IsArraySpec) {
                    IsArraySpec isArraySpec = (IsArraySpec)schema2;
                    JsArraySpec headSpec = isArraySpec.spec();
                    boolean nullable = isArraySpec.nullable();
                    Vector<Function<JsonReader<?>, JsValue>> headDeserializers = this.createDeserializers(headSpec.seq(), package$.MODULE$.Vector().empty());
                    result = result.appended(ValueParserFactory$.MODULE$.ofArraySpec(headDeserializers, nullable));
                    spec = (Seq)spec.tail();
                    continue;
                }
                if (schema2 instanceof JsArraySpec) {
                    JsArraySpec jsArraySpec = (JsArraySpec)schema2;
                    Seq<JsSpec> seq = jsArraySpec.seq();
                    result = result.appended(ValueParserFactory$.MODULE$.ofArraySpec(this.createDeserializers(seq, package$.MODULE$.Vector().empty()), false));
                    spec = (Seq)spec.tail();
                    continue;
                }
                if (schema2 instanceof ArrayOfObjSpec) {
                    ArrayOfObjSpec arrayOfObjSpec = (ArrayOfObjSpec)schema2;
                    JsObjSpec objSpec = arrayOfObjSpec.spec();
                    boolean nullable = arrayOfObjSpec.nullable();
                    boolean elemNullable = arrayOfObjSpec.elemNullable();
                    Tuple2<Vector<String>, Map<String, Function<JsonReader<?>, JsValue>>> tuple2 = JsObjParser$.MODULE$.createDeserializers(objSpec.map(), (Map<String, Function<JsonReader<?>, JsValue>>)HashMap$.MODULE$.empty(), (Vector<String>)package$.MODULE$.Vector().empty());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Vector value = (Vector)tuple2._1();
                    Map deserializers = (Map)tuple2._2();
                    Tuple2 tuple26 = new Tuple2((Object)value, (Object)deserializers);
                    Tuple2 tuple27 = tuple26;
                    Vector value2 = (Vector)tuple27._1();
                    Map deserializers4 = (Map)tuple27._2();
                    result = result.appended(ValueParserFactory$.MODULE$.ofArrayOfObjSpec((Vector<String>)value2, deserializers4, nullable, elemNullable));
                    spec = (Seq)spec.tail();
                    continue;
                }
                throw new MatchError((Object)schema2);
            }
            if (!(jsSpec instanceof JsPredicate)) break;
            JsPredicate jsPredicate = (JsPredicate)jsSpec;
            result = result.appended(Parser$.MODULE$.getDeserializer(jsPredicate)._2());
            spec = (Seq)spec.tail();
        }
        throw new MatchError((Object)jsSpec);
    }

    public JsArrayParser apply(Function<JsonReader<?>, JsValue> deserializer) {
        return new JsArrayParser(deserializer);
    }

    public Option<Function<JsonReader<?>, JsValue>> unapply(JsArrayParser x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.deserializer$access$0());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsArrayParser$.class);
    }

    private static final JsSpec head$1(Seq spec$1) {
        return (JsSpec)spec$1.head();
    }

    private JsArrayParser$() {
    }
}

