/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.serializers;

import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.NumberConverter;
import java.math.BigDecimal;
import java.util.Objects;
import json.value.JsArray;
import json.value.JsObj;
import json.value.JsValue;

public final class JsValueSerializer {
    private JsonWriter.WriteObject<JsObj> objectSerializer;
    private JsonWriter.WriteObject<JsArray> arraySerializer;

    public void setObjectSerializer(JsonWriter.WriteObject<JsObj> writeObject) {
        this.objectSerializer = Objects.requireNonNull(writeObject);
    }

    public void setArraySerializer(JsonWriter.WriteObject<JsArray> writeObject) {
        this.arraySerializer = Objects.requireNonNull(writeObject);
    }

    void serialize(JsonWriter jsonWriter, JsValue jsValue) {
        switch (jsValue.id()) {
            case 0: {
                jsonWriter.writeAscii(Boolean.toString(jsValue.toJsBool().value()));
                break;
            }
            case 1: {
                jsonWriter.writeNull();
                break;
            }
            case 2: {
                jsonWriter.writeString(jsValue.toJsStr().value());
                break;
            }
            case 3: {
                this.objectSerializer.write(jsonWriter, (Object)jsValue.toJsObj());
                break;
            }
            case 4: {
                this.arraySerializer.write(jsonWriter, (Object)jsValue.toJsArray());
                break;
            }
            case 5: 
            case 8: {
                NumberConverter.serialize((BigDecimal)jsValue.toJsBigDec().value().bigDecimal(), (JsonWriter)jsonWriter);
                break;
            }
            case 6: {
                jsonWriter.writeAscii(jsValue.toJsBigInt().value().bigInteger().toString());
                break;
            }
            case 7: {
                NumberConverter.serialize((long)jsValue.toJsLong().value(), (JsonWriter)jsonWriter);
                break;
            }
            case 9: {
                NumberConverter.serialize((int)jsValue.toJsInt().value(), (JsonWriter)jsonWriter);
                break;
            }
            default: {
                throw new IllegalStateException("JsValue.id() not considered. Default branch of a switch statement was executed.");
            }
        }
    }
}

