/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.derializers.types;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.derializers.arrays.JsArrayOfValueDeserializer;
import com.dslplatform.json.derializers.types.JsNumberDeserializer;
import com.dslplatform.json.derializers.types.JsObjDeserializer;
import com.dslplatform.json.derializers.types.JsTypeDeserializer;
import java.io.IOException;
import java.util.function.Function;
import json.value.FALSE$;
import json.value.JsNull$;
import json.value.JsStr;
import json.value.JsValue;
import json.value.TRUE$;
import json.value.spec.Result;
import json.value.spec.Valid$;

public final class JsValueDeserializer
extends JsTypeDeserializer {
    private JsObjDeserializer objDeserializer;
    private JsArrayOfValueDeserializer arrayDeserializer;
    private JsNumberDeserializer numberDeserializer;

    public void setNumberDeserializer(JsNumberDeserializer jsNumberDeserializer) {
        this.numberDeserializer = jsNumberDeserializer;
    }

    public void setObjDeserializer(JsObjDeserializer jsObjDeserializer) {
        this.objDeserializer = jsObjDeserializer;
    }

    public void setArrayDeserializer(JsArrayOfValueDeserializer jsArrayOfValueDeserializer) {
        this.arrayDeserializer = jsArrayOfValueDeserializer;
    }

    @Override
    public JsValue value(JsonReader<?> jsonReader) throws IOException {
        switch (jsonReader.last()) {
            case 116: {
                if (!jsonReader.wasTrue()) {
                    throw jsonReader.newParseErrorAt("Expecting 'true' for true constant", 0);
                }
                return TRUE$.MODULE$;
            }
            case 102: {
                if (!jsonReader.wasFalse()) {
                    throw jsonReader.newParseErrorAt("Expecting 'false' for false constant", 0);
                }
                return FALSE$.MODULE$;
            }
            case 34: {
                return new JsStr(jsonReader.readString());
            }
            case 123: {
                return this.objDeserializer.value((JsonReader)jsonReader);
            }
            case 91: {
                return this.arrayDeserializer.array(jsonReader);
            }
        }
        return this.numberDeserializer.value((JsonReader)jsonReader);
    }

    public JsValue valueSuchThat(JsonReader<?> jsonReader, Function<JsValue, Result> function) throws IOException {
        JsValue jsValue = this.value(jsonReader);
        Result result = function.apply(jsValue);
        if (result == Valid$.MODULE$) {
            return jsValue;
        }
        throw jsonReader.newParseError(result.toString());
    }

    public JsValue nullOrValueSuchThat(JsonReader<?> jsonReader, Function<JsValue, Result> function) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.valueSuchThat(jsonReader, function);
    }
}

