/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.derializers.types;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.derializers.types.JsTypeDeserializer;
import com.dslplatform.json.derializers.types.JsValueDeserializer;
import java.io.IOException;
import java.util.function.Function;
import json.value.JsNull$;
import json.value.JsObj;
import json.value.JsValue;
import json.value.spec.Result;
import json.value.spec.Valid$;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;

public final class JsObjDeserializer
extends JsTypeDeserializer {
    private final JsValueDeserializer valueDeserializer;

    public JsObjDeserializer(JsValueDeserializer jsValueDeserializer) {
        this.valueDeserializer = jsValueDeserializer;
    }

    @Override
    public JsObj value(JsonReader<?> jsonReader) throws IOException {
        byte by;
        if (this.isEmptyObj(jsonReader)) {
            return EMPTY_OBJ;
        }
        String string = jsonReader.readKey();
        HashMap hashMap = EMPTY_MAP.updated((Object)string, (Object)this.valueDeserializer.value(jsonReader));
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = jsonReader.readKey();
            hashMap = hashMap.updated((Object)string, (Object)this.valueDeserializer.value(jsonReader));
        }
        if (by != 125) {
            throw jsonReader.newParseError("Expecting '}' for map end");
        }
        return new JsObj((Map<String, JsValue>)hashMap);
    }

    public JsObj valueSuchThat(JsonReader<?> jsonReader, Function<JsObj, Result> function) throws IOException {
        JsValue jsValue = this.value((JsonReader)jsonReader);
        Result result = function.apply((JsObj)jsValue);
        if (result == Valid$.MODULE$) {
            return jsValue;
        }
        throw jsonReader.newParseError(result.toString());
    }

    public JsValue nullOrValueSuchThat(JsonReader<?> jsonReader, Function<JsObj, Result> function) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.valueSuchThat(jsonReader, function);
    }
}

