/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.derializers.types;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.derializers.types.JsTypeDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.function.Function;
import json.value.JsDouble;
import json.value.JsLong;
import json.value.JsNull$;
import json.value.JsNumber;
import json.value.JsValue;
import json.value.spec.Result;
import json.value.spec.Valid$;

public final class JsNumberDeserializer
extends JsTypeDeserializer {
    @Override
    public JsNumber value(JsonReader<?> jsonReader) throws IOException {
        Number number = NumberConverter.deserializeNumber(jsonReader);
        if (number instanceof Double) {
            return new JsDouble((Double)number);
        }
        if (number instanceof Long) {
            return new JsLong((Long)number);
        }
        if (number instanceof BigDecimal) {
            return this.toScalaBigDec((BigDecimal)number);
        }
        throw new RuntimeException("internal error: not condisered " + number.getClass());
    }

    public JsNumber valueSuchThat(JsonReader<?> jsonReader, Function<JsNumber, Result> function) throws IOException {
        JsValue jsValue = this.value((JsonReader)jsonReader);
        Result result = function.apply((JsNumber)jsValue);
        if (result == Valid$.MODULE$) {
            return jsValue;
        }
        throw jsonReader.newParseError(result.toString());
    }

    public JsValue nullOrValueSuchThat(JsonReader<?> jsonReader, Function<JsNumber, Result> function) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.valueSuchThat(jsonReader, function);
    }
}

