/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.derializers.types;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.MyNumberConverter;
import com.dslplatform.json.derializers.types.JsTypeDeserializer;
import java.io.IOException;
import java.math.BigInteger;
import java.util.function.Function;
import json.value.JsBigInt;
import json.value.JsNull$;
import json.value.JsValue;
import json.value.spec.Result;
import json.value.spec.Valid$;
import scala.math.BigInt;

public final class JsIntegralDeserializer
extends JsTypeDeserializer {
    @Override
    public JsBigInt value(JsonReader<?> jsonReader) throws IOException {
        try {
            return this.toScalaBigInt(MyNumberConverter.deserializeDecimal(jsonReader));
        }
        catch (ArithmeticException arithmeticException) {
            throw jsonReader.newParseError("Integral number expected");
        }
    }

    public JsBigInt valueSuchThat(JsonReader<?> jsonReader, Function<BigInteger, Result> function) throws IOException {
        BigInteger bigInteger = MyNumberConverter.deserializeDecimal(jsonReader).toBigIntegerExact();
        Result result = function.apply(bigInteger);
        if (result == Valid$.MODULE$) {
            return new JsBigInt(new BigInt(bigInteger));
        }
        throw jsonReader.newParseError(result.toString());
    }

    public JsValue nullOrValueSuchThat(JsonReader<?> jsonReader, Function<BigInteger, Result> function) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.valueSuchThat(jsonReader, function);
    }
}

