/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.derializers.arrays;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.derializers.arrays.JsArrayDeserializer;
import com.dslplatform.json.derializers.types.JsIntDeserializer;
import java.io.IOException;
import java.util.Objects;
import java.util.function.IntFunction;
import json.value.JsArray;
import json.value.JsNull$;
import json.value.JsValue;
import json.value.spec.Result;

public final class JsArrayOfIntDeserializer
extends JsArrayDeserializer {
    private JsIntDeserializer deserializer;

    public JsArrayOfIntDeserializer(JsIntDeserializer jsIntDeserializer) {
        super(Objects.requireNonNull(jsIntDeserializer));
        this.deserializer = jsIntDeserializer;
    }

    public JsValue nullOrArrayEachSuchThat(JsonReader<?> jsonReader, IntFunction<Result> intFunction) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.arrayEachSuchThat(jsonReader, intFunction);
    }

    public JsValue arrayWithNullEachSuchThat(JsonReader<?> jsonReader, IntFunction<Result> intFunction) throws IOException {
        if (jsonReader.last() != 91) {
            throw jsonReader.newParseError("Expecting '[' for list start");
        }
        jsonReader.getNextToken();
        JsArray jsArray = this.appendNullOrValue(jsonReader, intFunction, EMPTY);
        while (jsonReader.getNextToken() == 44) {
            jsonReader.getNextToken();
            jsArray = this.appendNullOrValue(jsonReader, intFunction, jsArray);
        }
        jsonReader.checkArrayEnd();
        return jsArray;
    }

    public JsValue nullOrArrayWithNullEachSuchThat(JsonReader<?> jsonReader, IntFunction<Result> intFunction) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.arrayWithNullEachSuchThat(jsonReader, intFunction);
    }

    public JsArray arrayEachSuchThat(JsonReader jsonReader, IntFunction<Result> intFunction) throws IOException {
        if (this.ifIsEmptyArray(jsonReader)) {
            return EMPTY;
        }
        JsArray jsArray = EMPTY.appended(this.deserializer.valueSuchThat(jsonReader, intFunction));
        while (jsonReader.getNextToken() == 44) {
            jsonReader.getNextToken();
            jsArray = jsArray.appended(this.deserializer.valueSuchThat(jsonReader, intFunction));
        }
        jsonReader.checkArrayEnd();
        return jsArray;
    }

    private JsArray appendNullOrValue(JsonReader<?> jsonReader, IntFunction<Result> intFunction, JsArray jsArray) throws IOException {
        return jsonReader.wasNull() ? jsArray.appended(JsNull$.MODULE$) : jsArray.appended(this.deserializer.valueSuchThat(jsonReader, intFunction));
    }
}

