/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.derializers.arrays;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.derializers.types.JsTypeDeserializer;
import java.io.IOException;
import java.util.function.Function;
import json.value.JsArray;
import json.value.JsArray$;
import json.value.JsNull$;
import json.value.JsValue;
import json.value.spec.Result;
import json.value.spec.Valid$;

public abstract class JsArrayDeserializer {
    static final JsArray EMPTY = JsArray$.MODULE$.empty();
    private final JsTypeDeserializer deserializer;

    public JsArrayDeserializer(JsTypeDeserializer jsTypeDeserializer) {
        this.deserializer = jsTypeDeserializer;
    }

    public JsValue nullOrArray(JsonReader<?> jsonReader) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.array(jsonReader);
    }

    public JsArray arrayWithNull(JsonReader<?> jsonReader) throws IOException {
        if (this.ifIsEmptyArray(jsonReader)) {
            return EMPTY;
        }
        JsArray jsArray = this.appendNullOrValue(jsonReader, EMPTY);
        while (jsonReader.getNextToken() == 44) {
            jsonReader.getNextToken();
            jsArray = this.appendNullOrValue(jsonReader, jsArray);
        }
        jsonReader.checkArrayEnd();
        return jsArray;
    }

    private JsArray appendNullOrValue(JsonReader<?> jsonReader, JsArray jsArray) throws IOException {
        return jsonReader.wasNull() ? jsArray.appended(JsNull$.MODULE$) : jsArray.appended(this.deserializer.value(jsonReader));
    }

    public JsValue nullOrArrayWithNull(JsonReader<?> jsonReader) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.arrayWithNull(jsonReader);
    }

    public JsArray array(JsonReader jsonReader) throws IOException {
        if (this.ifIsEmptyArray(jsonReader)) {
            return EMPTY;
        }
        JsArray jsArray = EMPTY.appended(this.deserializer.value(jsonReader));
        while (jsonReader.getNextToken() == 44) {
            jsonReader.getNextToken();
            jsArray = jsArray.appended(this.deserializer.value(jsonReader));
        }
        jsonReader.checkArrayEnd();
        return jsArray;
    }

    public JsValue nullOrArraySuchThat(JsonReader<?> jsonReader, Function<JsArray, Result> function) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.arraySuchThat(jsonReader, function);
    }

    public JsValue arrayWithNullSuchThat(JsonReader<?> jsonReader, Function<JsArray, Result> function) throws IOException {
        JsArray jsArray = this.arrayWithNull(jsonReader);
        Result result = function.apply(jsArray);
        if (result == Valid$.MODULE$) {
            return jsArray;
        }
        throw jsonReader.newParseError(result.toString());
    }

    public JsValue nullOrArrayWithNullSuchThat(JsonReader<?> jsonReader, Function<JsArray, Result> function) throws IOException {
        return jsonReader.wasNull() ? JsNull$.MODULE$ : this.arrayWithNullSuchThat(jsonReader, function);
    }

    public JsArray arraySuchThat(JsonReader jsonReader, Function<JsArray, Result> function) throws IOException {
        JsArray jsArray = this.array(jsonReader);
        Result result = function.apply(jsArray);
        if (result == Valid$.MODULE$) {
            return jsArray;
        }
        throw jsonReader.newParseError(result.toString());
    }

    boolean ifIsEmptyArray(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 91) {
            throw jsonReader.newParseError("Expecting '[' for list start");
        }
        jsonReader.getNextToken();
        return jsonReader.last() == 93;
    }
}

