/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.ParsingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

public abstract class MyNumberConverter {
    private static BigDecimal parseNumberGeneric(char[] cArray, int n, JsonReader jsonReader) throws ParsingException {
        int n2;
        for (n2 = n; n2 > 0 && Character.isWhitespace(cArray[n2 - 1]); --n2) {
        }
        if (n2 > jsonReader.maxNumberDigits) {
            throw jsonReader.newParseErrorWith("Too many digits detected in number", n, "", "Too many digits detected in number", (Object)n2, "");
        }
        try {
            return new BigDecimal(cArray, 0, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw jsonReader.newParseErrorAt("Error parsing number", n, (Exception)numberFormatException);
        }
    }

    private static NumberInfo readLongNumber(JsonReader jsonReader, int n) throws IOException {
        int n2 = jsonReader.length() - n;
        char[] cArray = jsonReader.prepareBuffer(n, n2);
        while (!jsonReader.isEndOfStream()) {
            int n3;
            while (n2 < cArray.length) {
                n3 = jsonReader.read();
                cArray[n2++] = n3;
                if (!jsonReader.isEndOfStream() && (n3 >= 48 && n3 <= 57 || n3 == 45 || n3 == 43 || n3 == 46 || n3 == 101 || n3 == 69)) continue;
                return new NumberInfo(cArray, n2);
            }
            n3 = cArray.length * 2;
            if (n3 > jsonReader.maxNumberDigits) {
                throw jsonReader.newParseErrorFormat("Too many digits detected in number", cArray.length, "Number of digits larger than %d. Unable to read number", new Object[]{jsonReader.maxNumberDigits});
            }
            cArray = Arrays.copyOf(cArray, n3);
        }
        return new NumberInfo(cArray, n2);
    }

    public static int deserializeInt(JsonReader jsonReader) throws IOException {
        int n = jsonReader.scanNumber();
        int n2 = jsonReader.getCurrentIndex();
        byte[] byArray = jsonReader.buffer;
        byte by = byArray[n];
        if (by == 45) {
            return MyNumberConverter.parseNegativeInt(byArray, jsonReader, n, n2);
        }
        return MyNumberConverter.parsePositiveInt(byArray, jsonReader, n, n2, 0);
    }

    private static int parsePositiveInt(byte[] byArray, JsonReader jsonReader, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = n + n3;
        if (n5 == n2) {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Digit not found");
        }
        while (n5 < n2) {
            int n6 = byArray[n5] - 48;
            if (n6 < 0 || n6 > 9) {
                BigDecimal bigDecimal;
                if (n5 > n + n3 && jsonReader.allWhitespace(n5, n2)) {
                    return n4;
                }
                if (n5 == n2 - 1 && byArray[n5] == 46) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Number ends with a dot");
                }
                if ((bigDecimal = MyNumberConverter.parseNumberGeneric(jsonReader.prepareBuffer(n, n2 - n), n2 - n, jsonReader)).scale() > 0) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Expecting int but found decimal json.value", (Object)bigDecimal);
                }
                return bigDecimal.intValue();
            }
            if ((n4 = (n4 << 3) + (n4 << 1) + n6) < 0) {
                NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Integer overflow detected");
            }
            ++n5;
        }
        return n4;
    }

    private static int parseNegativeInt(byte[] byArray, JsonReader jsonReader, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = n + 1;
        if (n4 == n2) {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Digit not found");
        }
        while (n4 < n2) {
            int n5 = byArray[n4] - 48;
            if (n5 < 0 || n5 > 9) {
                BigDecimal bigDecimal;
                if (n4 > n + 1 && jsonReader.allWhitespace(n4, n2)) {
                    return n3;
                }
                if (n4 == n2 - 1 && byArray[n4] == 46) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Number ends with a dot");
                }
                if ((bigDecimal = MyNumberConverter.parseNumberGeneric(jsonReader.prepareBuffer(n, n2 - n), n2 - n, jsonReader)).scale() > 0) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Expecting int but found decimal json.value", (Object)bigDecimal);
                }
                return bigDecimal.intValue();
            }
            if ((n3 = (n3 << 3) + (n3 << 1) - n5) > 0) {
                NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Integer overflow detected");
            }
            ++n4;
        }
        return n3;
    }

    public static long deserializeLong(JsonReader jsonReader) throws IOException {
        int n = jsonReader.scanNumber();
        int n2 = jsonReader.getCurrentIndex();
        byte[] byArray = jsonReader.buffer;
        byte by = byArray[n];
        int n3 = n;
        long l = 0L;
        if (by == 45) {
            n3 = n + 1;
            if (n3 == n2) {
                NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Digit not found");
            }
            while (n3 < n2) {
                int n4 = byArray[n3] - 48;
                if (n4 < 0 || n4 > 9) {
                    if (n3 > n + 1 && jsonReader.allWhitespace(n3, n2)) {
                        return l;
                    }
                    return MyNumberConverter.parseLongGeneric(jsonReader, n, n2);
                }
                if ((l = (l << 3) + (l << 1) - (long)n4) > 0L) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Long overflow detected");
                }
                ++n3;
            }
            return l;
        }
        if (n3 == n2) {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Digit not found");
        }
        while (n3 < n2) {
            int n5 = byArray[n3] - 48;
            if (n5 < 0 || n5 > 9) {
                if (by == 43 && n3 > n + 1 && jsonReader.allWhitespace(n3, n2)) {
                    return l;
                }
                if (by != 43 && n3 > n && jsonReader.allWhitespace(n3, n2)) {
                    return l;
                }
                return MyNumberConverter.parseLongGeneric(jsonReader, n, n2);
            }
            if ((l = (l << 3) + (l << 1) + (long)n5) < 0L) {
                NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Long overflow detected");
            }
            ++n3;
        }
        return l;
    }

    private static long parseLongGeneric(JsonReader jsonReader, int n, int n2) throws IOException {
        BigDecimal bigDecimal;
        int n3 = n2 - n;
        char[] cArray = jsonReader.prepareBuffer(n, n3);
        if (n3 > 0 && cArray[n3 - 1] == '.') {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Number ends with a dot");
        }
        if ((bigDecimal = MyNumberConverter.parseNumberGeneric(cArray, n3, jsonReader)).scale() > 0) {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Expecting long, but found decimal json.value ", (Object)bigDecimal);
        }
        return bigDecimal.longValue();
    }

    public static BigDecimal deserializeDecimal(JsonReader jsonReader) throws IOException {
        byte[] byArray;
        byte by;
        int n = jsonReader.scanNumber();
        int n2 = jsonReader.getCurrentIndex();
        int n3 = n2 - n;
        if (n3 > 18) {
            n2 = jsonReader.findNonWhitespace(n2);
            n3 = n2 - n;
            if (n2 == jsonReader.length()) {
                NumberInfo numberInfo = MyNumberConverter.readLongNumber(jsonReader, n);
                return MyNumberConverter.parseNumberGeneric(numberInfo.buffer, numberInfo.length, jsonReader);
            }
            if (n3 > 18) {
                return MyNumberConverter.parseNumberGeneric(jsonReader.prepareBuffer(n, n3), n3, jsonReader);
            }
        }
        if ((by = (byArray = jsonReader.buffer)[n]) == 45) {
            return MyNumberConverter.parseNegativeDecimal(byArray, jsonReader, n, n2);
        }
        return MyNumberConverter.parsePositiveDecimal(byArray, jsonReader, n, n2);
    }

    private static BigDecimal parsePositiveDecimal(byte[] byArray, JsonReader jsonReader, int n, int n2) throws IOException {
        int n3;
        int n4;
        long l = 0L;
        int n5 = 32;
        for (n4 = n; n4 < n2 && (n5 = byArray[n4]) != 46 && n5 != 101 && n5 != 69; ++n4) {
            n3 = n5 - 48;
            if (n3 < 0 || n3 > 9) {
                if (n4 > n && jsonReader.allWhitespace(n4, n2)) {
                    return BigDecimal.valueOf(l);
                }
                NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Unknown digit", (Object)Character.valueOf((char)n5));
            }
            l = (l << 3) + (l << 1) + (long)n3;
        }
        if (n4 == n) {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Digit not found");
        } else {
            if (n4 == n2) {
                return BigDecimal.valueOf(l);
            }
            if (n5 == 46) {
                int n6;
                if (++n4 == n2) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Number ends with a dot");
                }
                n3 = n4;
                while (n4 < n2 && (n5 = byArray[n4]) != 101 && n5 != 69) {
                    n6 = n5 - 48;
                    if (n6 < 0 || n6 > 9) {
                        if (jsonReader.allWhitespace(n4, n2)) {
                            return BigDecimal.valueOf(l, n4 - n3);
                        }
                        NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Unknown digit", (Object)Character.valueOf((char)n5));
                    }
                    l = (l << 3) + (l << 1) + (long)n6;
                    ++n4;
                }
                if (n4 == n2) {
                    return BigDecimal.valueOf(l, n2 - n3);
                }
                if (n5 == 101 || n5 == 69) {
                    n6 = n4++;
                    n5 = byArray[n4];
                    int n7 = n5 == 45 ? MyNumberConverter.parseNegativeInt(byArray, jsonReader, n4, n2) : (n5 == 43 ? MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 1) : MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 0));
                    return BigDecimal.valueOf(l, n6 - n3 - n7);
                }
                return BigDecimal.valueOf(l, n2 - n3);
            }
            if (n5 == 101 || n5 == 69) {
                n3 = (n5 = byArray[++n4]) == 45 ? MyNumberConverter.parseNegativeInt(byArray, jsonReader, n4, n2) : (n5 == 43 ? MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 1) : MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 0));
                return BigDecimal.valueOf(l, -n3);
            }
        }
        return BigDecimal.valueOf(l);
    }

    private static BigDecimal parseNegativeDecimal(byte[] byArray, JsonReader jsonReader, int n, int n2) throws IOException {
        int n3;
        int n4;
        long l = 0L;
        int n5 = 32;
        for (n4 = n + 1; n4 < n2 && (n5 = byArray[n4]) != 46 && n5 != 101 && n5 != 69; ++n4) {
            n3 = n5 - 48;
            if (n3 < 0 || n3 > 9) {
                if (n4 > n + 1 && jsonReader.allWhitespace(n4, n2)) {
                    return BigDecimal.valueOf(l);
                }
                NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Unknown digit", (Object)Character.valueOf((char)n5));
            }
            l = (l << 3) + (l << 1) - (long)n3;
        }
        if (n4 == n + 1) {
            NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Digit not found");
        } else {
            if (n4 == n2) {
                return BigDecimal.valueOf(l);
            }
            if (n5 == 46) {
                int n6;
                if (++n4 == n2) {
                    NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Number ends with a dot");
                }
                n3 = n4;
                while (n4 < n2 && (n5 = byArray[n4]) != 101 && n5 != 69) {
                    n6 = n5 - 48;
                    if (n6 < 0 || n6 > 9) {
                        if (jsonReader.allWhitespace(n4, n2)) {
                            return BigDecimal.valueOf(l, n4 - n3);
                        }
                        NumberConverter.numberException((JsonReader)jsonReader, (int)n, (int)n2, (String)"Unknown digit", (Object)Character.valueOf((char)n5));
                    }
                    l = (l << 3) + (l << 1) - (long)n6;
                    ++n4;
                }
                if (n4 == n2) {
                    return BigDecimal.valueOf(l, n2 - n3);
                }
                if (n5 == 101 || n5 == 69) {
                    n6 = n4++;
                    n5 = byArray[n4];
                    int n7 = n5 == 45 ? MyNumberConverter.parseNegativeInt(byArray, jsonReader, n4, n2) : (n5 == 43 ? MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 1) : MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 0));
                    return BigDecimal.valueOf(l, n6 - n3 - n7);
                }
                return BigDecimal.valueOf(l, n2 - n3);
            }
            if (n5 == 101 || n5 == 69) {
                n3 = (n5 = byArray[++n4]) == 45 ? MyNumberConverter.parseNegativeInt(byArray, jsonReader, n4, n2) : (n5 == 43 ? MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 1) : MyNumberConverter.parsePositiveInt(byArray, jsonReader, n4, n2, 0));
                return BigDecimal.valueOf(l, -n3);
            }
        }
        return BigDecimal.valueOf(l);
    }

    static class NumberInfo {
        final char[] buffer;
        final int length;

        NumberInfo(char[] cArray, int n) {
            this.buffer = cArray;
            this.length = n;
        }
    }
}

