/*
 * Decompiled with CFR 0.152.
 */
package value.spec;

import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import value.JsNumber;
import value.JsValue;
import value.spec.Invalid;
import value.spec.Invalid$;
import value.spec.JsSpec;
import value.spec.JsValueSpec;
import value.spec.JsValueSpec$;
import value.spec.Messages$;
import value.spec.Result;
import value.spec.Valid$;

public final class JsNumberSpecs$ {
    public static final JsNumberSpecs$ MODULE$ = new JsNumberSpecs$();
    private static final JsValueSpec integral = new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> value.isInt() || value.isLong() || value.isBigInt() ? Valid$.MODULE$ : Invalid$.MODULE$.apply((String)Messages$.MODULE$.INTEGRAL_NUMBER_NOT_FOUND().apply(value)));
    private static final JsValueSpec decimal = new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> value.isDouble() || value.isBigDec() ? Valid$.MODULE$ : Invalid$.MODULE$.apply((String)Messages$.MODULE$.DECIMAL_NUMBER_NOT_FOUND().apply(value)));
    private static final JsValueSpec number = new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> value.isNumber() ? Valid$.MODULE$ : Invalid$.MODULE$.apply((String)Messages$.MODULE$.NUMBER_NOT_FOUND().apply(value)));

    public JsValueSpec integral() {
        return integral;
    }

    public JsValueSpec decimal() {
        return decimal;
    }

    public JsValueSpec number() {
        return number;
    }

    public JsSpec number(Function1<JsNumber, Object> condition, String message) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.number(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)value.asJsNumber())) ? Valid$.MODULE$ : Invalid$.MODULE$.apply(message))}));
    }

    public JsValueSpec decimal(BigDecimal minimum, BigDecimal maximum, BigDecimal multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.decimal(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigDecimal n = value.asJsBigDec().value();
            Seq errors = (Seq)Seq$.MODULE$.empty();
            if (n.$less((Object)minimum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_LOWER_THAN_MINIMUM().apply(value, (Object)minimum));
            }
            if (n.$greater((Object)maximum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_GREATER_THAN_MAXIMUM().apply(value, (Object)maximum));
            }
            if (!BoxesRunTime.equalsNumObject((Number)multipleOf, (Object)BoxesRunTime.boxToInteger((int)0)) && !BoxesRunTime.equalsNumObject((Number)n.$percent(multipleOf), (Object)BoxesRunTime.boxToInteger((int)0))) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_NOT_MULTIPLE_OF().apply(value, (Object)multipleOf));
            }
            return errors.isEmpty() ? Valid$.MODULE$ : new Invalid((Seq<String>)errors);
        })}));
    }

    public JsValueSpec decimalGT(BigDecimal exclusiveMinimum, BigDecimal multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.decimal(), this.decimalGTE(exclusiveMinimum, multipleOf), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigDecimal n;
            BigDecimal bigDecimal = n = value.asJsBigDec().value();
            BigDecimal bigDecimal2 = exclusiveMinimum;
            return !(bigDecimal != null ? !bigDecimal.equals(bigDecimal2) : bigDecimal2 != null) ? Invalid$.MODULE$.apply((String)Messages$.MODULE$.DECIMAL_EQUAL_TO_EXCLUSIVE_MINIMUM().apply(value, (Object)exclusiveMinimum)) : Valid$.MODULE$;
        })}));
    }

    public JsValueSpec decimalGTE(BigDecimal minimum, BigDecimal multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.decimal(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigDecimal n = value.asJsBigDec().value();
            Seq errors = (Seq)Seq$.MODULE$.empty();
            if (n.$less((Object)minimum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_LOWER_THAN_MINIMUM().apply(value, (Object)minimum));
            }
            if (!BoxesRunTime.equalsNumObject((Number)multipleOf, (Object)BoxesRunTime.boxToInteger((int)0)) && !BoxesRunTime.equalsNumObject((Number)n.$percent(multipleOf), (Object)BoxesRunTime.boxToInteger((int)0))) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_NOT_MULTIPLE_OF().apply(value, (Object)multipleOf));
            }
            return errors.isEmpty() ? Valid$.MODULE$ : new Invalid((Seq<String>)errors);
        })}));
    }

    public JsValueSpec decimalLTE(BigDecimal maximum, BigDecimal multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.decimal(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigDecimal n = value.asJsBigDec().value();
            Seq errors = (Seq)Seq$.MODULE$.empty();
            if (n.$greater((Object)maximum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_GREATER_THAN_MAXIMUM().apply(value, (Object)maximum));
            }
            if (!BoxesRunTime.equalsNumObject((Number)multipleOf, (Object)BoxesRunTime.boxToInteger((int)0)) && !BoxesRunTime.equalsNumObject((Number)n.$percent(multipleOf), (Object)BoxesRunTime.boxToInteger((int)0))) {
                errors = (Seq)errors.appended(Messages$.MODULE$.DECIMAL_NOT_MULTIPLE_OF().apply(value, (Object)multipleOf));
            }
            return errors.isEmpty() ? Valid$.MODULE$ : new Invalid((Seq<String>)errors);
        })}));
    }

    public JsValueSpec decimalLT(BigDecimal exclusiveMaximum, BigDecimal multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.decimal(), this.decimalLTE(exclusiveMaximum, multipleOf), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigDecimal n;
            BigDecimal bigDecimal = n = value.asJsBigDec().value();
            BigDecimal bigDecimal2 = exclusiveMaximum;
            return !(bigDecimal != null ? !bigDecimal.equals(bigDecimal2) : bigDecimal2 != null) ? Invalid$.MODULE$.apply((String)Messages$.MODULE$.DECIMAL_EQUAL_TO_EXCLUSIVE_MAXIMUM().apply(value, (Object)exclusiveMaximum)) : Valid$.MODULE$;
        })}));
    }

    public JsValueSpec decimal(Function1<BigDecimal, Object> condition, Function1<BigDecimal, String> errorMessage) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.decimal(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)value.asJsBigDec().value())) ? Valid$.MODULE$ : Invalid$.MODULE$.apply((String)errorMessage.apply((Object)value.asJsBigDec().value())))}));
    }

    public BigDecimal decimal$default$3() {
        return BigDecimal$.MODULE$.int2bigDecimal(0);
    }

    public BigDecimal decimalGT$default$2() {
        return BigDecimal$.MODULE$.int2bigDecimal(0);
    }

    public BigDecimal decimalGTE$default$2() {
        return BigDecimal$.MODULE$.int2bigDecimal(0);
    }

    public BigDecimal decimalLTE$default$2() {
        return BigDecimal$.MODULE$.int2bigDecimal(0);
    }

    public BigDecimal decimalLT$default$2() {
        return BigDecimal$.MODULE$.int2bigDecimal(0);
    }

    public JsValueSpec integral(BigInt minimum, BigInt maximum, BigInt multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.integral(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigInt n = value.asJsBigInt().value();
            Seq errors = (Seq)Seq$.MODULE$.empty();
            if (n.$less((Object)minimum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_LOWER_THAN_MINIMUM().apply(value, (Object)minimum));
            }
            if (n.$greater((Object)maximum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_GREATER_THAN_MAXIMUM().apply(value, (Object)maximum));
            }
            if (!BoxesRunTime.equalsNumObject((Number)multipleOf, (Object)BoxesRunTime.boxToInteger((int)0)) && !BoxesRunTime.equalsNumObject((Number)n.$percent(multipleOf), (Object)BoxesRunTime.boxToInteger((int)0))) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_NOT_MULTIPLE_OF().apply(value, (Object)multipleOf));
            }
            return errors.isEmpty() ? Valid$.MODULE$ : new Invalid((Seq<String>)errors);
        })}));
    }

    public JsValueSpec integralGT(BigInt exclusiveMinimum, BigInt multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.integral(), this.integralGTE(exclusiveMinimum, multipleOf), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigInt n;
            BigInt bigInt = n = value.asJsBigInt().value();
            BigInt bigInt2 = exclusiveMinimum;
            return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null) ? Invalid$.MODULE$.apply((String)Messages$.MODULE$.INTEGRAL_EQUAL_TO_EXCLUSIVE_MINIMUM().apply(value, (Object)exclusiveMinimum)) : Valid$.MODULE$;
        })}));
    }

    public JsValueSpec integralGTE(BigInt minimum, BigInt multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.integral(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigInt n = value.asJsBigInt().value();
            Seq errors = (Seq)Seq$.MODULE$.empty();
            if (n.$less((Object)minimum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_LOWER_THAN_MINIMUM().apply(value, (Object)minimum));
            }
            if (!BoxesRunTime.equalsNumObject((Number)multipleOf, (Object)BoxesRunTime.boxToInteger((int)0)) && !BoxesRunTime.equalsNumObject((Number)n.$percent(multipleOf), (Object)BoxesRunTime.boxToInteger((int)0))) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_NOT_MULTIPLE_OF().apply(value, (Object)multipleOf));
            }
            return errors.isEmpty() ? Valid$.MODULE$ : new Invalid((Seq<String>)errors);
        })}));
    }

    public JsValueSpec integralLTE(BigInt maximum, BigInt multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.integral(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigInt n = value.asJsBigInt().value();
            Seq errors = (Seq)Seq$.MODULE$.empty();
            if (n.$greater((Object)maximum)) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_GREATER_THAN_MAXIMUM().apply(value, (Object)maximum));
            }
            if (!BoxesRunTime.equalsNumObject((Number)multipleOf, (Object)BoxesRunTime.boxToInteger((int)0)) && !BoxesRunTime.equalsNumObject((Number)n.$percent(multipleOf), (Object)BoxesRunTime.boxToInteger((int)0))) {
                errors = (Seq)errors.appended(Messages$.MODULE$.INTEGRAL_NOT_MULTIPLE_OF().apply(value, (Object)multipleOf));
            }
            return errors.isEmpty() ? Valid$.MODULE$ : new Invalid((Seq<String>)errors);
        })}));
    }

    public JsValueSpec integralLT(BigInt exclusiveMaximum, BigInt multipleOf) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.integral(), this.integralLTE(exclusiveMaximum, multipleOf), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> {
            BigInt n;
            BigInt bigInt = n = value.asJsBigInt().value();
            BigInt bigInt2 = exclusiveMaximum;
            return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null) ? Invalid$.MODULE$.apply((String)Messages$.MODULE$.INTEGRAL_EQUAL_TO_EXCLUSIVE_MAXIMUM().apply(value, (Object)exclusiveMaximum)) : Valid$.MODULE$;
        })}));
    }

    public JsValueSpec integral(Function1<BigInt, Object> condition, Function1<BigInt, String> message) {
        return JsValueSpec$.MODULE$.and((Seq<JsValueSpec>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsValueSpec[]{this.integral(), new JsValueSpec((Function1<JsValue, Result>)(Function1 & Serializable)value -> BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)value.asJsBigInt().value())) ? Valid$.MODULE$ : Invalid$.MODULE$.apply((String)message.apply((Object)value.asJsBigInt().value())))}));
    }

    public BigInt integral$default$3() {
        return BigInt$.MODULE$.int2bigInt(0);
    }

    public BigInt integralGT$default$2() {
        return BigInt$.MODULE$.int2bigInt(0);
    }

    public BigInt integralGTE$default$2() {
        return BigInt$.MODULE$.int2bigInt(0);
    }

    public BigInt integralLTE$default$2() {
        return BigInt$.MODULE$.int2bigInt(0);
    }

    public BigInt integralLT$default$2() {
        return BigInt$.MODULE$.int2bigInt(0);
    }

    private JsNumberSpecs$() {
    }
}

