package valuegen

import value.JsObj
import org.scalacheck.Gen

object RandomJsObjGen
{
  def apply(objectPrimitiveGen: PrimitiveGen = PrimitiveGen(),
            arrayPrimitiveGen : PrimitiveGen = PrimitiveGen(),
            arrLengthGen      : Gen[Int] = Gen.choose(0,
                                                      10
                                                      ),
            objSizeGen        : Gen[Int] = Gen.choose(0,
                                                      10
                                                      ),
            keyGen            : Gen[String] = Gen.oneOf(ALPHABET),
            arrayValueFreq    : ValueFreq = ValueFreq(),
            objectValueFreq   : ValueFreq = ValueFreq()
           ): Gen[JsObj] =
  {

    RandomJsGen(objectPrimitiveGen,
                arrayPrimitiveGen,
                arrLengthGen,
                objSizeGen,
                keyGen,
                arrayValueFreq,
                objectValueFreq
                ).obj
  }

}
