package valuegen

import org.scalacheck.{Arbitrary, Gen}
import value.{JsBool, JsNull, JsStr, JsValue}

object JsValueGen
{

  def apply(): Gen[JsValue] =
    Gen.oneOf(JsObjGen(),
              JsArrayGen(),
              JsNumberGen(),
              Arbitrary.arbitrary[String].map(JsStr),
              Gen.oneOf(false,true).map(JsBool),
              Gen.const(JsNull)
              )

}
