package valuegen

import org.scalacheck.{Arbitrary, Gen}
import value.{JsBigDec, JsBigInt, JsDouble, JsInt, JsLong, JsNumber}

object JsNumberGen
{

  val intGen: Gen[JsInt] = Arbitrary.arbitrary[Int].map(JsInt)
  val doubleGen: Gen[JsDouble] = Arbitrary.arbitrary[Double].map(JsDouble)
  val longGen: Gen[JsLong] = Arbitrary.arbitrary[Long].map(JsLong)
  val bigDecGen: Gen[JsBigDec] = Arbitrary.arbitrary[BigDecimal].map(JsBigDec)
  val bigIntGen: Gen[JsBigInt] = Arbitrary.arbitrary[BigInt].map(JsBigInt)

  def apply(): Gen[JsNumber] = Gen.oneOf(intGen,
                                         doubleGen,
                                         longGen,
                                         bigDecGen,
                                         bigIntGen
                                         )


}
