package valuegen

import value.Preamble._
import value.{JsArray, JsPath, JsValue}
import org.scalacheck.Gen

import scala.collection.immutable

object JsArrayGen
{
  def inserted(gen  : Gen[JsArray],
               pairs: (JsPath, Gen[JsValue])*
              ): Gen[JsArray] =
  {
    if (pairs.count(pair => pair._1.head.isKey) > 0) throw new UnsupportedOperationException("head of a path is a key")

    valuegen.inserted(gen,
                      pairs: _*
                      )
  }


  def of(gen: Gen[JsValue]): Gen[JsArray] = Gen.containerOf[immutable.Seq, JsValue](gen).map(v => JsArray(v))

  def noneEmptyOf(gen: Gen[JsValue]): Gen[JsArray] = Gen.nonEmptyContainerOf[immutable.Seq, JsValue](gen).map(v => JsArray(v))

  def ofN(n  : Int,
          gen: Gen[JsValue]
         ): Gen[JsArray] =
  {
    if (n == 0) Gen.const(JsArray())
    Gen.containerOfN[immutable.Seq, JsValue](n,
                                             gen
                                             ).map(v => JsArray(v))
  }

  def apply(seq: Gen[JsValue]*): Gen[JsArray] =
  {
    @scala.annotation.tailrec
    def arrGenRec(acc : Gen[JsArray],
                  gens: collection.Seq[Gen[JsValue]]
                 ): Gen[JsArray] =
    {

      if (gens.isEmpty) acc
      else arrGenRec(acc.flatMap(a => gens.head.map(e => a.appended(e))),
                     gens.tail
                     )

    }

    arrGenRec(Gen.const(JsArray()),
              seq
              )
  }

  def fromPairs(pairs: (JsPath, Gen[JsValue])*): Gen[JsArray] =
  {
    if (pairs.count(pair => pair._1.head.isKey) > 0)
      throw new UnsupportedOperationException("head of a path is a key")
    genFromPairs[JsArray](Gen.const(JsArray()),
                          pairs
                          )
  }
}
