package valuegen

import value.Implicits._
import value.{JsArray, JsObj, JsPath, JsValue, Json}
import org.scalacheck.Gen


final case class JsPairGen(pair: (JsPath, Gen[JsValue]))
{
  override def equals(that: Any): Boolean = false

  def +:[T <: Json[T]](gen: Gen[T]): Gen[T] = valuegen.inserted(gen,this.pair)

}

object JsPairGen
{

  def obj(pairs: (JsPath, Gen[JsValue])*): Gen[JsObj] =
  {
    if (pairs.count(pair => pair._1.head.isIndex) > 0) throw new UnsupportedOperationException("head of a path is an index")
    genFromPairs[JsObj](Gen.const(JsObj()),
                        pairs
                        )
  }

  def array(pairs: (JsPath, Gen[JsValue])*): Gen[JsArray] =
  {
    if (pairs.count(pair => pair._1.head.isKey) > 0) throw new UnsupportedOperationException("head of a path is a key")
    genFromPairs[JsArray](Gen.const(JsArray()),
                          pairs
                          )
  }


}
