package valuegen

import value.{JsObj, JsPath, JsValue}
import org.scalacheck.Gen
import value.Implicits._

/**
 * Represents a Json object generator.
 *
 */
object JsObjGen
{


  def inserted(gen: Gen[JsObj],
               pairs: (JsPath, Gen[JsValue])*
              ): Gen[JsObj] =
  {
    if (pairs.count(pair => pair._1.head.isIndex) > 0) throw new UnsupportedOperationException("head of a path is an index")

    valuegen.inserted(gen,
                      pairs: _*
                      )
  }


  def concat(a             : Gen[JsObj],
             b             : Gen[JsObj],
             rest          : Gen[JsObj]*
            ): Gen[JsObj] = valuegen.concat(a,
                                            b,
                                            rest:_*
                                            )


  def apply(pairs: (String, Gen[JsValue])*): Gen[JsObj] =
  {
    @scala.annotation.tailrec
    def objGenRec(acc: Gen[JsObj],
                  seq: Seq[(String, Gen[JsValue])]
                 ): Gen[JsObj] =
    {
      if (seq.isEmpty) acc
      else
      {
        val (key, gen) = seq.head
        objGenRec(acc.flatMap(o => gen.map(e => o.updated(key,
                                                          e
                                                          )
                                           )
                              ),
                  seq.tail
                  )
      }
    }

    objGenRec(Gen.const(JsObj()),
              pairs
              )
  }

}
