package fun.gen;


import java.util.*;
import java.util.function.Supplier;
import java.util.random.RandomGenerator;
import java.util.random.RandomGeneratorFactory;

import static java.util.Objects.requireNonNull;


/**
 * A generator for creating records. This generator provides a flexible way to define the fields and their corresponding
 * generators for generating records. You can specify which fields are optional and nullable, allowing you to generate
 * records with varying structures.
 *
 * <p>With {@code RecordGen}, you can easily generate custom records for testing and data generation purposes. It enables
 * you to control the generation of each field, making it suitable for generating diverse data for your record-based classes.
 * A common use case involves defining a generator for a custom Java object by creating a Record and then using the
 * {@link Gen#map} function to transform the generated record into your desired custom object.</p>
 */
public final class RecordGen implements Gen<Record> {

    private final static Supplier<Set<String>> EMPTY_SET_GEN = HashSet::new;
    private final SplitGen split;
    private final List<String> optionals;
    private final List<String> nullables;
    private final Map<String, Gen<?>> bindings;

    private RecordGen(Map<String, Gen<?>> bindings,
                      List<String> optionals,
                      List<String> nullables) {
        for (String key : optionals) {
            if (!bindings.containsKey(key))
                throw new IllegalArgumentException("optional '" + key + "' not defined in generator");
        }
        for (String key : nullables) {
            if (!bindings.containsKey(key))
                throw new IllegalArgumentException("nullable '" + key + "' not defined in generator");
        }
        this.optionals = optionals;
        this.nullables = nullables;
        this.bindings = bindings;
        this.split = SplitGen.DEFAULT;

    }


    private RecordGen(final Map<String, Gen<?>> bindings) {
        this(bindings,
             new ArrayList<>(),
             new ArrayList<>());
    }

    public static RecordGen of() {
        Map<String, Gen<?>> map = new HashMap<>();
        return new RecordGen(map);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen) {
        Map<String, Gen<?>> map = new HashMap<>();
        map.put(requireNonNull(key),
                requireNonNull(gen));
        return new RecordGen(map);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1) {
        return RecordGen.of(key,
                            gen).set(key1,
                                     gen1);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1).set(key2,
                                      gen2);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2).set(key3,
                                      gen3);

    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3).set(key4,
                                      gen4);

    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4).set(key5,
                                      gen5);

    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5).set(key6,
                                      gen6);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6).set(key7,
                                      gen7);

    }

    @SuppressWarnings("squid:S00107")
    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7).set(key8,
                                      gen8);

    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8).set(key9,
                                      gen9);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9).set(key10,
                                      gen10);
    }

    public static RecordGen of(final String key,
                               final Gen<?> gen,
                               final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11) {
        return RecordGen.of(key,
                            gen,
                            key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10).set(key11,
                                       gen11);

    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13) {

        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12).set(key13,
                                       gen13);
    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13).set(key14,
                                       gen14);
    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14,
                               final String key15,
                               final Gen<?> gen15) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14).set(key15,
                                       gen15);

    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14,
                               final String key15,
                               final Gen<?> gen15,
                               final String key16,
                               final Gen<?> gen16) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15).set(key16,
                                       gen16);

    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14,
                               final String key15,
                               final Gen<?> gen15,
                               final String key16,
                               final Gen<?> gen16,
                               final String key17,
                               final Gen<?> gen17) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16).set(key17,
                                       gen17);

    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14,
                               final String key15,
                               final Gen<?> gen15,
                               final String key16,
                               final Gen<?> gen16,
                               final String key17,
                               final Gen<?> gen17,
                               final String key18,
                               final Gen<?> gen18) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17).set(key18,
                                       gen18);

    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14,
                               final String key15,
                               final Gen<?> gen15,
                               final String key16,
                               final Gen<?> gen16,
                               final String key17,
                               final Gen<?> gen17,
                               final String key18,
                               final Gen<?> gen18,
                               final String key19,
                               final Gen<?> gen19) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18).set(key19,
                                       gen19);

    }

    public static RecordGen of(final String key1,
                               final Gen<?> gen1,
                               final String key2,
                               final Gen<?> gen2,
                               final String key3,
                               final Gen<?> gen3,
                               final String key4,
                               final Gen<?> gen4,
                               final String key5,
                               final Gen<?> gen5,
                               final String key6,
                               final Gen<?> gen6,
                               final String key7,
                               final Gen<?> gen7,
                               final String key8,
                               final Gen<?> gen8,
                               final String key9,
                               final Gen<?> gen9,
                               final String key10,
                               final Gen<?> gen10,
                               final String key11,
                               final Gen<?> gen11,
                               final String key12,
                               final Gen<?> gen12,
                               final String key13,
                               final Gen<?> gen13,
                               final String key14,
                               final Gen<?> gen14,
                               final String key15,
                               final Gen<?> gen15,
                               final String key16,
                               final Gen<?> gen16,
                               final String key17,
                               final Gen<?> gen17,
                               final String key18,
                               final Gen<?> gen18,
                               final String key19,
                               final Gen<?> gen19,
                               final String key20,
                               final Gen<?> gen20) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19).set(key20,
                                       gen20);

    }

    // Method for 21 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20).set(key21,
                                       gen21);
    }

    // Method for 22 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21).set(key22,
                                       gen22);
    }

    // Method for 23 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22).set(key23,
                                       gen23);
    }

    // Method for 24 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23).set(key24,
                                       gen24);
    }

    // Method for 25 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24,
                               String key25,
                               Gen<?> gen25) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23,
                            key24,
                            gen24).set(key25,
                                       gen25);
    }

    // Method for 26 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24,
                               String key25,
                               Gen<?> gen25,
                               String key26,
                               Gen<?> gen26) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23,
                            key24,
                            gen24,
                            key25,
                            gen25).set(key26,
                                       gen26);
    }

    // Method for 27 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24,
                               String key25,
                               Gen<?> gen25,
                               String key26,
                               Gen<?> gen26,
                               String key27,
                               Gen<?> gen27) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23,
                            key24,
                            gen24,
                            key25,
                            gen25,
                            key26,
                            gen26).set(key27,
                                       gen27);
    }

    // Method for 28 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24,
                               String key25,
                               Gen<?> gen25,
                               String key26,
                               Gen<?> gen26,
                               String key27,
                               Gen<?> gen27,
                               String key28,
                               Gen<?> gen28) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23,
                            key24,
                            gen24,
                            key25,
                            gen25,
                            key26,
                            gen26,
                            key27,
                            gen27).set(key28,
                                       gen28);
    }

    // Method for 29 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24,
                               String key25,
                               Gen<?> gen25,
                               String key26,
                               Gen<?> gen26,
                               String key27,
                               Gen<?> gen27,
                               String key28,
                               Gen<?> gen28,
                               String key29,
                               Gen<?> gen29) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23,
                            key24,
                            gen24,
                            key25,
                            gen25,
                            key26,
                            gen26,
                            key27,
                            gen27,
                            key28,
                            gen28).set(key29,
                                       gen29);
    }

    // Method for 30 parameters
    public static RecordGen of(String key1,
                               Gen<?> gen1,
                               String key2,
                               Gen<?> gen2,
                               String key3,
                               Gen<?> gen3,
                               String key4,
                               Gen<?> gen4,
                               String key5,
                               Gen<?> gen5,
                               String key6,
                               Gen<?> gen6,
                               String key7,
                               Gen<?> gen7,
                               String key8,
                               Gen<?> gen8,
                               String key9,
                               Gen<?> gen9,
                               String key10,
                               Gen<?> gen10,
                               String key11,
                               Gen<?> gen11,
                               String key12,
                               Gen<?> gen12,
                               String key13,
                               Gen<?> gen13,
                               String key14,
                               Gen<?> gen14,
                               String key15,
                               Gen<?> gen15,
                               String key16,
                               Gen<?> gen16,
                               String key17,
                               Gen<?> gen17,
                               String key18,
                               Gen<?> gen18,
                               String key19,
                               Gen<?> gen19,
                               String key20,
                               Gen<?> gen20,
                               String key21,
                               Gen<?> gen21,
                               String key22,
                               Gen<?> gen22,
                               String key23,
                               Gen<?> gen23,
                               String key24,
                               Gen<?> gen24,
                               String key25,
                               Gen<?> gen25,
                               String key26,
                               Gen<?> gen26,
                               String key27,
                               Gen<?> gen27,
                               String key28,
                               Gen<?> gen28,
                               String key29,
                               Gen<?> gen29,
                               String key30,
                               Gen<?> gen30) {
        return RecordGen.of(key1,
                            gen1,
                            key2,
                            gen2,
                            key3,
                            gen3,
                            key4,
                            gen4,
                            key5,
                            gen5,
                            key6,
                            gen6,
                            key7,
                            gen7,
                            key8,
                            gen8,
                            key9,
                            gen9,
                            key10,
                            gen10,
                            key11,
                            gen11,
                            key12,
                            gen12,
                            key13,
                            gen13,
                            key14,
                            gen14,
                            key15,
                            gen15,
                            key16,
                            gen16,
                            key17,
                            gen17,
                            key18,
                            gen18,
                            key19,
                            gen19,
                            key20,
                            gen20,
                            key21,
                            gen21,
                            key22,
                            gen22,
                            key23,
                            gen23,
                            key24,
                            gen24,
                            key25,
                            gen25,
                            key26,
                            gen26,
                            key27,
                            gen27,
                            key28,
                            gen28,
                            key29,
                            gen29).set(key30,
                                       gen30);
    }

    public static void main(String[] args) {


        RandomGenerator random = RandomGeneratorFactory.getDefault().create();
        for (int i = 0; i < 100; i++) {
            Supplier<Boolean> isRemoveOpts = BoolGen.arbitrary()
                                                    .apply(SplitGen.DEFAULT
                                                                   .apply(random));
            Supplier<Boolean> isSetNullables = BoolGen.arbitrary()
                                                      .apply(SplitGen.DEFAULT
                                                                     .apply(random));
            System.out.println(isRemoveOpts.get());
            System.out.println(isSetNullables.get());
        }


    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * the specified nullable keys. The value associated with a nullable key may or may not be null.
     *
     * @param nullables The nullable keys.
     * @return A brand new record generator.
     */
    public RecordGen withNullValues(final Collection<String> nullables) {
        return new RecordGen(bindings,
                             optionals,
                             new ArrayList<>(requireNonNull(nullables)));
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * all keys nullable. The value associated with a nullable key may or may not be null.
     *
     * @return A brand new record generator.
     */
    public RecordGen withAllNullValues() {
        return new RecordGen(bindings,
                             optionals,
                             new ArrayList<>(bindings.keySet()));
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * the specified nullable keys. The value associated with a nullable key may or may not be null.
     *
     * @param nullables The nullable keys.
     * @return A brand new record generator.
     */
    public RecordGen withNullValues(final String... nullables) {
        List<String> xs = new ArrayList<>();
        Collections.addAll(xs,
                           requireNonNull(nullables));
        return new RecordGen(bindings,
                             optionals,
                             xs);
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * the specified optional keys. An optional key may or may not appear in the generated record objects.
     *
     * @param optionals The optional keys.
     * @return A brand new record generator.
     */
    public RecordGen withOptKeys(final Collection<String> optionals) {
        return new RecordGen(bindings,
                             new ArrayList<>(requireNonNull(optionals)),
                             nullables);
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * the specified required keys. A required key must appear in the generated record.
     *
     * @param reqKeys The required keys.
     * @return A brand new record generator.
     */
    public RecordGen withReqKeys(final Collection<String> reqKeys) {
        return new RecordGen(bindings,
                             new ArrayList<>(reqKeys),
                             nullables);
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * the specified optional keys. An optional key may or may not appear in the generated record.
     *
     * @param optionals The optional keys.
     * @return A brand new record generator.
     */
    public RecordGen withOptKeys(final String... optionals) {
        List<String> xs = new ArrayList<>();
        Collections.addAll(xs,
                           requireNonNull(optionals));
        return new RecordGen(bindings,
                             xs,
                             nullables);
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * the specified required keys. A required key must appear in the generated record.
     *
     * @param reqKeys The required keys.
     * @return A brand new record generator.
     */
    public RecordGen withReqKeys(final String... reqKeys) {
        List<String> keys = new ArrayList<>(bindings.keySet());
        for (String reqKey : reqKeys) keys.remove(reqKey);
        return new RecordGen(bindings,
                             keys,
                             nullables);
    }

    /**
     * Returns a brand new record generator with the same key-generators pairs as this instance and
     * all keys optional. An optional key may or may not appear in the generated records.
     *
     * @return A brand new JsObj generator.
     */
    public RecordGen withAllOptKeys() {
        return new RecordGen(bindings,
                             new ArrayList<>(bindings.keySet()),
                             nullables);
    }

    /**
     * Sets a specific field and its corresponding generator for the generated records.
     *
     * @param key The name of the field to set.
     * @param gen The generator for the field's values.
     * @return A new RecordGen instance with the updated field binding.
     */
    public RecordGen set(final String key,
                         final Gen<?> gen) {
        LinkedHashMap<String, Gen<?>> b = new LinkedHashMap<>(bindings);
        b.put(key,
              gen);
        return new RecordGen(b,
                             optionals,
                             nullables);
    }

    @Override
    public Supplier<Record> apply(final RandomGenerator random) {
        Objects.requireNonNull(random);
        var optionalFields =
                optionals.isEmpty() ?
                EMPTY_SET_GEN :
                new SubsetGen<>(optionals).suchThat(set -> !set.isEmpty())
                                          .apply(split.apply(random));

        var nullableFields =
                nullables.isEmpty() ?
                EMPTY_SET_GEN :
                new SubsetGen<>(nullables)
                        .suchThat(set -> !set.isEmpty())
                        .apply(split.apply(random));

        var isRemoveOpts = BoolGen.arbitrary()
                                  .apply(random);
        var isSetNullables = BoolGen.arbitrary()
                                    .apply(random);


        Map<String, Supplier<?>> map = new LinkedHashMap<>();
        for (var pair : bindings.entrySet()) {
            var value = pair.getValue();
            map.put(pair.getKey(),
                    value.apply(split.apply(random))
            );
        }


        return () -> {

            var nullFields = isSetNullables.get() ?
                             nullableFields.get() :
                             null;


            var optFields = isRemoveOpts.get() ?
                            optionalFields.get() :
                            null;


            Map<String, Object> result = new LinkedHashMap<>();

            for (var pair : map.entrySet()) {
                if (optFields == null || !optFields.contains(pair.getKey())) {
                    Object value =
                            nullFields != null && nullFields.contains(pair.getKey()) ?
                            null :
                            pair.getValue().get();
                    result.put(pair.getKey(),
                               value);
                }
            }

            return new Record(result);
        };


    }

}
