/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.github.hwywl.model.Aggregation;
import com.github.hwywl.model.Condition;
import com.github.hwywl.model.Join;
import com.github.hwywl.model.QueryModel;
import com.github.hwywl.model.Table;
import com.github.hwywl.sql.JoinOperators;
import com.github.hwywl.sql.SqlCreate;
import java.util.List;
import java.util.stream.Collectors;

public class JsonToSqlUtil {
    public static String jsonGeneratedSql(String jsonStr) throws NullPointerException {
        return JsonToSqlUtil.beanGeneratedSql((QueryModel)JSONUtil.toBean((String)jsonStr, QueryModel.class));
    }

    public static String beanGeneratedSql(QueryModel queryModel) throws NullPointerException {
        Table tableAlias = queryModel.getTable();
        SqlCreate resultSqlCreate = JsonToSqlUtil.getSqlCreate(tableAlias, queryModel.getJoins(), queryModel.getCondition());
        List<Join> joins = queryModel.getJoins();
        List<String> groupBy = queryModel.getGroupBy();
        if (CollUtil.isNotEmpty(groupBy)) {
            queryModel.setFields(groupBy);
        }
        if (!CollUtil.isEmpty(joins)) {
            for (Join join : joins) {
                if (join == null || !StrUtil.isNotEmpty((CharSequence)join.getJoinType())) continue;
                SqlCreate sqlCreate = SqlCreate.create();
                Table joinTableAlias = join.getTable();
                List<String> fields = join.getFields();
                List<Aggregation> aggregations = join.getAggregation();
                List<Condition> conditions = join.getCondition();
                List<Condition> joinCondition = join.getJoinCondition();
                String joinSql = CollUtil.isEmpty(fields) ? joinTableAlias.getTableName() : sqlCreate.tableAlias(joinTableAlias.getTableName(), joinTableAlias.getAlias()).fields((String[])ArrayUtil.toArray(fields, String.class)).aggregations(aggregations, joinTableAlias.getAlias()).andConditions(conditions).groupBy(CollUtil.isEmpty(join.getGroupBy()) ? new String[]{} : (String[])ArrayUtil.toArray(join.getGroupBy(), String.class)).orderBys(join.getOrderBy()).limit(queryModel.getLimit()).build();
                resultSqlCreate = resultSqlCreate.joinCondition(joinCondition).join(StrUtil.isEmpty((CharSequence)joinSql) ? null : joinSql, StrUtil.isEmpty((CharSequence)joinSql) ? null : joinTableAlias.getAlias(), StrUtil.isEmpty((CharSequence)joinSql) ? null : JoinOperators.valueOf(join.getJoinType()));
            }
        }
        resultSqlCreate.fields((String[])ArrayUtil.toArray(queryModel.getFields(), String.class)).aggregations(queryModel.getAggregation(), tableAlias.getAlias()).andConditions(queryModel.getCondition()).groupBy(queryModel.getGroupBy() == null || queryModel.getGroupBy().isEmpty() ? new String[]{} : (String[])ArrayUtil.toArray(queryModel.getGroupBy(), String.class)).orderBys(queryModel.getOrderBy()).limit(queryModel.getLimit()).build();
        return resultSqlCreate.build();
    }

    private static SqlCreate getSqlCreate(Table tableAlias, List<Join> joins, List<Condition> condition) throws NullPointerException {
        SqlCreate resultSqlCreate = SqlCreate.create();
        if (CollUtil.isNotEmpty(joins)) {
            List tableNames = joins.stream().map(e -> e.getTable().getTableName()).collect(Collectors.toList());
            List alias = joins.stream().map(e -> e.getTable().getAlias()).collect(Collectors.toList());
            if (tableNames.contains(tableAlias.getTableName()) && alias.contains(tableAlias.getAlias())) {
                resultSqlCreate = resultSqlCreate.table();
            }
        } else {
            if (CollUtil.isEmpty(condition)) {
                throw new NullPointerException("\u8fde\u63a5\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            resultSqlCreate = resultSqlCreate.tableAlias(tableAlias.getTableName(), tableAlias.getAlias());
        }
        return resultSqlCreate;
    }
}

