/*
 * Decompiled with CFR 0.152.
 */
package com.github.hwywl.sql;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.github.hwywl.model.Aggregation;
import com.github.hwywl.model.Condition;
import com.github.hwywl.model.Limit;
import com.github.hwywl.model.OrderBy;
import com.github.hwywl.sql.AggregationOperators;
import com.github.hwywl.sql.JoinOperators;
import com.github.hwywl.sql.LogicalOperators;
import com.github.hwywl.sql.RelationalOperators;
import com.github.hwywl.sql.SqlCondition;
import com.github.hwywl.sql.SqlOperate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlCreate {
    private StringBuffer sql = new StringBuffer();
    private Map<String, Object> operateFields = new HashMap<String, Object>();
    private ArrayList<Object> operateValues = new ArrayList();
    private ArrayList<String> fields = new ArrayList();
    private ArrayList<SqlCondition> conditions = new ArrayList();
    private ArrayList<SqlCondition> joinConditions = new ArrayList();
    private String operate = "";
    private String table = "";
    private String limit = "";
    private String order = "";
    private String group = "";

    public SqlCreate() {
        this.operate = SqlOperate.SELECT;
    }

    public static SqlCreate create() {
        return new SqlCreate();
    }

    public SqlCreate(String table) {
        this.table = table;
        this.operate = SqlOperate.SELECT;
    }

    public SqlCreate(String operate, String table) {
        this.operate = operate;
        this.table = table;
    }

    public SqlCreate operate(String operate) {
        this.operate = operate;
        return this;
    }

    public SqlCreate operateFiled(String properName, Object properValue) {
        this.operateFields.put(properName, properValue);
        return this;
    }

    public SqlCreate operateFiled(Map<String, Object> fields) {
        this.operateFields.putAll(fields);
        return this;
    }

    public SqlCreate operateFiled(Object properValue) {
        this.operateValues.add(properValue);
        return this;
    }

    public SqlCreate field(String field) {
        this.fields.add(field);
        return this;
    }

    public SqlCreate aggregation(String field, AggregationOperators operator) {
        String agg = StrUtil.format((CharSequence)operator.getTemplate(), (Map)Dict.create().set("field", (Object)field).set("alias", (Object)operator.getName()));
        this.fields.add(agg);
        return this;
    }

    public SqlCreate aggregation(String field, AggregationOperators operator, String alias) {
        String agg = StrUtil.format((CharSequence)operator.getTemplate(), (Map)Dict.create().set("field", (Object)field).set("alias", (Object)alias));
        this.fields.add(agg);
        return this;
    }

    public SqlCreate aggregations(List<Aggregation> aggregations, String tableAlias) {
        if (aggregations == null || aggregations.isEmpty()) {
            return this;
        }
        for (Aggregation value : aggregations) {
            AggregationOperators aggregationOperator;
            String alias = value.getAlias();
            if (StrUtil.isEmpty((CharSequence)alias)) {
                String attribute = value.getField();
                String[] attributes = attribute.split("\\.");
                attribute = attributes.length > 1 ? attributes[1] : attribute;
                alias = tableAlias + "_" + value.getAggregationMode() + "_" + attribute;
            }
            if ((aggregationOperator = AggregationOperators.getAggregationOperator(value.getAggregationMode())) == null) continue;
            this.aggregation(value.getField(), aggregationOperator, "\"" + alias + "\"");
        }
        return this;
    }

    public SqlCreate fieldAll(String fields) {
        String[] fieldArray = fields.split(",");
        Collections.addAll(this.fields, fieldArray);
        return this;
    }

    public SqlCreate fields(String ... field) {
        Collections.addAll(this.fields, field);
        return this;
    }

    public SqlCreate field(String field, String alias) {
        this.fields.add(field + " as " + alias);
        return this;
    }

    public SqlCreate table() {
        return this;
    }

    public SqlCreate table(String table) {
        this.table = table;
        return this;
    }

    public SqlCreate tableAlias(String table, String alias) {
        this.table = this.table + table + " as " + alias + " ";
        return this;
    }

    public SqlCreate join(String resultOrTable, String alias, JoinOperators joinType) {
        if (StrUtil.isNotEmpty((CharSequence)resultOrTable) || joinType != null) {
            this.table = joinType == JoinOperators.Query_Subsystem ? (StrUtil.isNotEmpty((CharSequence)this.table) ? this.table + " ,(" + resultOrTable + ")  as " + alias : this.table + " (" + resultOrTable + ")  as " + alias) : (StrUtil.isNotEmpty((CharSequence)this.table) ? this.table + " " + (Object)((Object)joinType) + " join (" + resultOrTable + ")  as " + alias + this.assembleJoinCondition() : this.table + " (" + resultOrTable + ")  as " + alias + this.assembleJoinCondition());
        }
        return this;
    }

    public SqlCreate joinCondition(List<Condition> jc) {
        if (!CollUtil.isEmpty(jc)) {
            for (Condition value : jc) {
                this.andJoinCondition(value.getAboveConditions(), value.getField(), value.getMiddleConditions(), value.getFieldValue());
            }
        }
        return this;
    }

    public SqlCreate andCondition(String field, String operator, Object value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            this.andCondition(LogicalOperators.AND, operator, field, this.filterValue(value));
        }
        return this;
    }

    public SqlCreate andJoinCondition(String field, String operator, Object value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            this.andJoinCondition(LogicalOperators.AND, operator, field, this.filterValue(value));
        }
        return this;
    }

    public SqlCreate andCondition(String logical, String field, String operator, Object value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            if (operator.toLowerCase().equals(RelationalOperators.IN)) {
                this.conditionIn(logical, RelationalOperators.IN, field, Arrays.asList(value.toString().split(",")));
            } else if (operator.toLowerCase().equals(RelationalOperators.NOT_IN)) {
                this.conditionIn(logical, RelationalOperators.NOT_IN, field, Arrays.asList(value.toString().split(",")));
            } else if (operator.toLowerCase().equals(RelationalOperators.BETWEEN)) {
                this.conditionBetween(logical, RelationalOperators.BETWEEN, field, Arrays.asList(value.toString().split(",")));
            } else {
                this.conditions.add(new SqlCondition(logical, operator, field, this.filterValue(value)));
            }
        } else if (operator.toLowerCase().equals(RelationalOperators.IS_NOT_NULL) || operator.toLowerCase().equals(RelationalOperators.IS_NULL)) {
            this.conditions.add(new SqlCondition(logical, operator, field, ""));
        }
        return this;
    }

    public SqlCreate andJoinCondition(String logical, String field, String operator, Object value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            if (operator.toLowerCase().equals(RelationalOperators.IN)) {
                this.joinConditionIn(logical, RelationalOperators.IN, field, Arrays.asList(value.toString().split(",")));
            } else if (operator.toLowerCase().equals(RelationalOperators.NOT_IN)) {
                this.joinConditionIn(logical, RelationalOperators.NOT_IN, field, Arrays.asList(value.toString().split(",")));
            } else if (operator.toLowerCase().equals(RelationalOperators.BETWEEN)) {
                this.joinConditionBetween(logical, RelationalOperators.BETWEEN, field, Arrays.asList(value.toString().split(",")));
            } else {
                this.joinConditions.add(new SqlCondition(logical, operator, field, this.filterValue(value)));
            }
        }
        return this;
    }

    public SqlCreate andConditions(List<Condition> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return this;
        }
        for (Condition value : conditions) {
            this.andCondition(value.getAboveConditions(), value.getField(), value.getMiddleConditions(), value.getFieldValue());
        }
        return this;
    }

    public SqlCreate orCondition(String field, String operator, Object value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            this.conditions.add(new SqlCondition(LogicalOperators.OR, operator, field, this.filterValue(value)));
        }
        return this;
    }

    public SqlCreate andLike(String field, String value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            value = "%" + value + "%";
            this.andCondition(field, "like", value);
        }
        return this;
    }

    public SqlCreate orLike(String field, String value) {
        if (!ObjectUtil.isEmpty((Object)value)) {
            value = "%" + value + "%";
            this.orCondition(field, "like", value);
        }
        return this;
    }

    public <T> SqlCreate andConditionIn(String field, List<T> values) {
        return this.conditionIn(LogicalOperators.AND, RelationalOperators.IN, field, values);
    }

    public <T> SqlCreate orConditionIn(String field, List<T> values) {
        return this.conditionIn(LogicalOperators.OR, RelationalOperators.IN, field, values);
    }

    public <T> SqlCreate andConditionNotIn(String field, List<T> values) {
        return this.conditionIn(LogicalOperators.AND, RelationalOperators.NOT_IN, field, values);
    }

    public <T> SqlCreate orConditionNotIn(String field, List<T> values) {
        return this.conditionIn(LogicalOperators.OR, RelationalOperators.NOT_IN, field, values);
    }

    private <T> SqlCreate conditionIn(String logicalOperators, String relationalOperators, String field, List<T> values) {
        String build;
        if (!values.isEmpty() && StrUtil.isNotEmpty((CharSequence)(build = this.inConditionBuild(values)))) {
            this.conditions.add(new SqlCondition(logicalOperators, relationalOperators, field, build));
        }
        return this;
    }

    private <T> SqlCreate conditionBetween(String logicalOperators, String relationalOperators, String field, List<T> values) {
        String build;
        if (!values.isEmpty() && StrUtil.isNotEmpty((CharSequence)(build = this.betweenConditionBuild(values)))) {
            this.conditions.add(new SqlCondition(logicalOperators, relationalOperators, field, build));
        }
        return this;
    }

    private <T> SqlCreate joinConditionIn(String logicalOperators, String relationalOperators, String field, List<T> values) {
        String build;
        if (!values.isEmpty() && StrUtil.isNotEmpty((CharSequence)(build = this.inConditionBuild(values)))) {
            this.joinConditions.add(new SqlCondition(logicalOperators, relationalOperators, field, build));
        }
        return this;
    }

    private <T> SqlCreate joinConditionBetween(String logicalOperators, String relationalOperators, String field, List<T> values) {
        String build;
        if (!values.isEmpty() && StrUtil.isNotEmpty((CharSequence)(build = this.betweenConditionBuild(values)))) {
            this.joinConditions.add(new SqlCondition(logicalOperators, relationalOperators, field, build));
        }
        return this;
    }

    private <T> String inConditionBuild(List<T> values) {
        if (!values.isEmpty()) {
            StringBuilder conditionStr = new StringBuilder();
            conditionStr.append(" (");
            for (T value : values) {
                conditionStr.append(this.filterValue(value)).append(" ,");
            }
            conditionStr.delete(conditionStr.length() - 1, conditionStr.length());
            conditionStr.append(") ");
            return conditionStr.toString();
        }
        return null;
    }

    private <T> String betweenConditionBuild(List<T> values) {
        if (!values.isEmpty()) {
            StringBuilder conditionStr = new StringBuilder();
            conditionStr.append(" ");
            for (T value : values) {
                conditionStr.append(this.filterValue(value)).append(" and ");
            }
            conditionStr.delete(conditionStr.length() - 4, conditionStr.length());
            conditionStr.append(" ");
            return conditionStr.toString();
        }
        return null;
    }

    private String filterValue(Object value) {
        if (value instanceof String && !((String)value).contains(".") && !((String)value).contains("'")) {
            if (NumberUtil.isNumber((CharSequence)value.toString())) {
                return value.toString();
            }
            return "'" + value + "'";
        }
        if (value instanceof Date) {
            return "'" + value + "'";
        }
        return value.toString();
    }

    public SqlCreate orderBys(List<OrderBy> orderBys) {
        if (orderBys == null || orderBys.isEmpty()) {
            return this;
        }
        StringBuilder oby = new StringBuilder();
        for (OrderBy value : orderBys) {
            for (String field : value.getFields()) {
                oby.append(field).append(",");
            }
            String ob = oby.substring(0, oby.length() - 1) + " " + value.getSort() + ",";
            oby.setLength(0);
            oby.append(ob);
        }
        this.order = oby.substring(0, oby.length() - 1);
        return this;
    }

    public SqlCreate groupBy(String ... fields) {
        StringBuilder groupBy = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            groupBy.append(fields[i]);
            if (i == fields.length - 1) continue;
            groupBy.append(",");
        }
        this.group = groupBy.toString();
        return this;
    }

    public String build() {
        this.sql.setLength(0);
        switch (this.operate) {
            case "select": {
                return this.selectToSql();
            }
        }
        return null;
    }

    private void assembleFiled() {
        if (this.fields.size() > 0) {
            for (String filed : this.fields) {
                if (!filed.equals(this.fields.get(this.fields.size() - 1))) {
                    this.sql = this.sql.append(" ").append(filed).append(",");
                    continue;
                }
                this.sql = this.sql.append(" ").append(filed);
            }
        } else {
            this.sql = this.sql.append(" *");
        }
    }

    private void assembleCondition() {
        if (!this.conditions.isEmpty()) {
            boolean first = true;
            this.sql = this.sql.append(" where ");
            for (SqlCondition condition : this.conditions) {
                if (first) {
                    this.sql.append(" ").append(condition.getField()).append(" ").append(condition.getRelationOperator()).append(" ").append(condition.getValue());
                    first = false;
                    continue;
                }
                this.sql.append(" ").append(condition.getLogicalOperator()).append(" ").append(condition.getField()).append(" ").append(condition.getRelationOperator()).append(" ").append(condition.getValue());
            }
        }
    }

    private String assembleJoinCondition() {
        if (!this.joinConditions.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            builder.append(" on ");
            for (SqlCondition condition : this.joinConditions) {
                if (first) {
                    builder.append(" ").append(condition.getField()).append(" ").append(condition.getRelationOperator()).append(" ").append(condition.getValue());
                    first = false;
                    continue;
                }
                builder.append(" ").append(condition.getLogicalOperator()).append(" ").append(condition.getField()).append(" ").append(condition.getRelationOperator()).append(" ").append(condition.getValue());
            }
            this.joinConditions.clear();
            return builder.toString();
        }
        return " ";
    }

    private void assembleOrder() {
        if (!this.order.isEmpty()) {
            this.sql.append(" order by ").append(this.order);
        }
    }

    private void assembleGroup() {
        if (!this.group.isEmpty()) {
            this.sql.append(" group by ").append(this.group);
        }
    }

    public SqlCreate limit(Limit limitConditions) {
        int typeOfDatabase;
        if (limitConditions == null || limitConditions.getPageSize() == null || limitConditions.getPageStart() == null) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" ").append("limit").append(" ");
        int n = typeOfDatabase = limitConditions.getTypeOfDatabase() == null ? 0 : limitConditions.getTypeOfDatabase();
        if (typeOfDatabase == 0) {
            builder.append(limitConditions.getPageStart()).append(",").append(limitConditions.getPageSize());
        } else if (typeOfDatabase == 1) {
            builder.append(limitConditions.getPageSize()).append(" ").append("offset").append(" ").append(limitConditions.getPageStart());
        }
        this.limit = builder.toString();
        return this;
    }

    private void assembleKeyValue() {
        if (!this.operateFields.isEmpty()) {
            this.sql = this.sql.append(" SET");
            for (String key : this.operateFields.keySet()) {
                Object value = this.operateFields.get(key);
                this.sql = this.sql.append(" ").append(key).append(" = ").append(this.filterValue(value)).append(",");
            }
            this.sql = this.sql.deleteCharAt(this.sql.length() - 1);
        }
    }

    private void assembleLimit() {
        if (!this.limit.isEmpty()) {
            this.sql.append(this.limit);
        }
    }

    private String selectToSql() {
        this.sql = this.sql.append(SqlOperate.SELECT);
        this.assembleFiled();
        this.sql = this.sql.append(" from ").append(this.table);
        this.assembleCondition();
        this.assembleGroup();
        this.assembleOrder();
        this.assembleLimit();
        return this.sql.toString();
    }
}

