/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbbbbb.cachespringbootstarter.aspects;

import com.github.houbbbbb.cachespringbootstarter.annotations.MapCacheAnnotation;
import com.github.houbbbbb.cachespringbootstarter.utils.PrintUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class MapCacheAspect {
    private static final Map<String, Object> MAP = new HashMap();

    @Pointcut(value="@annotation(com.github.houbbbbb.cachespringbootstarter.annotations.MapCacheAnnotation)")
    private void mapCacheCut() {
    }

    @Around(value="mapCacheCut()")
    public Object mapCacheAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = joinPoint.getTarget().getClass().getMethod(signature.getName(), signature.getMethod().getParameterTypes());
        MapCacheAnnotation annotation = method.getAnnotation(MapCacheAnnotation.class);
        String name = annotation.name();
        String key = annotation.key();
        boolean value = annotation.value();
        String namePrefix = name.concat("_");
        Object o = null;
        if (value) {
            String finalKey = this.parse(joinPoint, method, key);
            String finalName = namePrefix.concat(finalKey);
            if (MAP.containsKey(finalName)) {
                o = MAP.get(finalName);
                PrintUtils.println((String)"cache get", (Object)finalName);
            } else {
                o = joinPoint.proceed();
                MAP.put(finalName, o);
                PrintUtils.println((String)"cache put", (Object)finalName);
            }
        } else {
            Set keySets = MAP.keySet();
            for (String pr : keySets) {
                if (!pr.startsWith(namePrefix)) continue;
                MAP.remove(pr);
            }
            o = joinPoint.proceed();
            PrintUtils.println((String)"mapCache remove prefix", (Object)name);
        }
        return o;
    }

    private String parse(ProceedingJoinPoint joinPoint, Method method, String key) {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(key);
        StandardEvaluationContext context = new StandardEvaluationContext();
        Object[] params = joinPoint.getArgs();
        String[] paraNames = new DefaultParameterNameDiscoverer().getParameterNames(method);
        int len = paraNames.length;
        for (int i = 0; i < len; ++i) {
            context.setVariable(paraNames[i], params[i]);
        }
        return expression.getValue((EvaluationContext)context).toString();
    }
}

