package com.github.houbb.jdbc.api.support;


/**
 * @author binbin.hou
 * @since 0.0.3
 */
public interface ITypeHandlerRegister {

    /**
     * 注册处理类
     * @param javaType java 类型
     * @param handler 处理类
     * @param <T> 泛型
     * @return 结果
     * @since 0.0.3
     */
    <T> ITypeHandlerRegister register(final Class<T> javaType,
                                      final ITypeHandler<? extends T> handler);

    /**
     * 获取类型处理类
     * @param javaType 类型
     * @param <T> 泛型
     * @return 结果
     * @since 0.0.3
     */
    <T> ITypeHandler<? extends T> getTypeHandler(final Class<T> javaType);

}
