package com.github.houbb.jdbc.api.support;


import com.github.houbb.constant.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 直接使用 mybatis 的接口
 * @author binbin.hou
 * @since 0.0.4
 */
public interface ITypeHandler<T> {

    /**
     * 设置参数类型
     * @param ps 准备信息
     * @param i 下标
     * @param parameter 参数
     * @param jdbcType 类型
     * @throws SQLException 异常
     * @since 0.0.4
     */
    void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException;

    /**
     * 设置参数类型
     * @param ps 准备信息
     * @param i 下标
     * @param parameter 参数
     * @throws SQLException 异常
     * @since 0.0.4
     */
    void setParameter(PreparedStatement ps, int i, T parameter) throws SQLException;

    /**
     * 获取结果
     * @param rs 结果
     * @param columnName 名称
     * @return 结果
     * @throws SQLException 异常
     * @since 0.0.4
     */
    T getResult(ResultSet rs, String columnName) throws SQLException;

    /**
     * 获取结果
     * @param rs 结果
     * @param columnName 名称
     * @param jdbcType jdbc 类型
     * @return 结果
     * @throws SQLException 异常
     * @since 0.0.4
     */
    T getResult(ResultSet rs, String columnName, JdbcType jdbcType) throws SQLException;

    /**
     * 获取结果
     * @param rs 结果
     * @param columnIndex 索引
     * @return 结果
     * @throws SQLException 异常
     * @since 0.0.4
     */
    T getResult(ResultSet rs, int columnIndex) throws SQLException;

    /**
     * 获取结果
     * @param rs 结果
     * @param columnIndex 索引
     * @param jdbcType 类型
     * @return 结果
     * @throws SQLException 异常
     * @since 0.0.4
     */
    T getResult(ResultSet rs, int columnIndex, JdbcType jdbcType) throws SQLException;

    /**
     * 获取结果
     * @param cs cs
     * @param columnIndex 下标
     * @return 结果
     * @throws SQLException 异常
     * @since 0.0.4
     */
    T getResult(CallableStatement cs, int columnIndex) throws SQLException;

}
