package com.github.houbb.jdbc.api.support;

import com.github.houbb.constant.JdbcType;

import java.lang.reflect.Field;

/**
 * @author binbin.hou
 * @since 0.0.1
 */
public interface IColumn {

    /**
     * 原始字段信息
     * @return 字段信息
     */
    Field field();

    /**
     * 表名称
     * @return 表名称
     */
    String name();

    /**
     * 字段类型
     * 1. 需要进行数据库和 Java 类型的映射
     * 2. 如果为 String 类型，则需要设置为 sta.setString(2, "XXX")
     * @return 字段类型
     */
    Class<?> type();

    /**
     * 字段值
     * 1. 在构建模板的时候，可以不初始化。在真正设置值的时候再初始化。
     * @return 字段值
     */
    Object value();

    /**
     * 是否忽略当前列
     * @return 是否
     * @since 0.0.3
     */
    boolean ignore();

    /**
     * jdbc 类型
     * @return 类型
     * @since 0.0.4
     */
    JdbcType jdbcType();

}
