package com.github.houbb.jdbc.api.dal;

import com.github.houbb.constant.JdbcType;
import com.github.houbb.jdbc.api.support.ITypeHandler;

/**
 * @author binbin.hou
 * @since 0.0.3
 */
public interface IPrepareInfo {

    /**
     * 参数对应的索引
     * @return 索引
     * @since 0.0.3
     */
    int parameterIndex();

    /**
     * 对应的值
     * @return 值
     * @since 0.0.3
     */
    Object value();

    /**
     * 对应的 sql 类型
     * @return 类型
     * @since 0.0.3
     */
    ITypeHandler typeHandler();

    /**
     * jdbc 类型
     * @return 类型
     * @since 0.0.4
     */
    JdbcType jdbcType();

}
